/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import me.desht.pneumaticcraft.api.drone.IDrone;
import me.desht.pneumaticcraft.api.drone.IProgWidget;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.drone.ai.DroneAIRightClickBlock;
import me.desht.pneumaticcraft.common.drone.progwidgets.IBlockRightClicker;
import me.desht.pneumaticcraft.common.drone.progwidgets.IMaxActions;
import me.desht.pneumaticcraft.common.drone.progwidgets.ISidedWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetAreaItemBase;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetDigAndPlace;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetPlace;
import me.desht.pneumaticcraft.common.registry.ModProgWidgetTypes;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.core.Direction;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.ai.goal.Goal;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public class ProgWidgetBlockRightClick
extends ProgWidgetPlace
implements IBlockRightClicker,
ISidedWidget {
    public static final MapCodec<ProgWidgetBlockRightClick> CODEC = RecordCodecBuilder.mapCodec(builder -> ProgWidgetBlockRightClick.digPlaceParts(builder).and(builder.group((App)Direction.CODEC.optionalFieldOf("side", (Object)Direction.UP).forGetter(ProgWidgetBlockRightClick::getClickSide), (App)Codec.BOOL.optionalFieldOf("sneaking", (Object)false).forGetter(ProgWidgetBlockRightClick::isSneaking), (App)StringRepresentable.fromEnum(IBlockRightClicker.RightClickType::values).optionalFieldOf("click_type", (Object)IBlockRightClicker.RightClickType.CLICK_ITEM).forGetter(ProgWidgetBlockRightClick::getClickType))).apply((Applicative)builder, ProgWidgetBlockRightClick::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ProgWidgetBlockRightClick> STREAM_CODEC = StreamCodec.composite(ProgWidget.PositionFields.STREAM_CODEC, ProgWidget::getPosition, ProgWidgetDigAndPlace.DigPlaceFields.STREAM_CODEC, p -> p.digPlaceFields, (StreamCodec)Direction.STREAM_CODEC, ProgWidgetBlockRightClick::getClickSide, (StreamCodec)ByteBufCodecs.BOOL, ProgWidgetBlockRightClick::isSneaking, (StreamCodec)NeoForgeStreamCodecs.enumCodec(IBlockRightClicker.RightClickType.class), ProgWidgetBlockRightClick::getClickType, ProgWidgetBlockRightClick::new);
    private Direction clickSide = Direction.UP;
    private boolean sneaking;
    private IBlockRightClicker.RightClickType clickType = IBlockRightClicker.RightClickType.CLICK_ITEM;

    public ProgWidgetBlockRightClick(ProgWidget.PositionFields pos, ProgWidgetDigAndPlace.DigPlaceFields digPlaceFields, Direction clickSide, boolean sneaking, IBlockRightClicker.RightClickType clickType) {
        super(pos, digPlaceFields);
        this.clickSide = clickSide;
        this.sneaking = sneaking;
        this.clickType = clickType;
    }

    public ProgWidgetBlockRightClick() {
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_BLOCK_RIGHT_CLICK;
    }

    @Override
    public ProgWidgetType<?> getType() {
        return ModProgWidgetTypes.BLOCK_RIGHT_CLICK.get();
    }

    @Override
    public Goal getWidgetAI(IDrone drone, IProgWidget widget) {
        return this.setupMaxActions(new DroneAIRightClickBlock(drone, (ProgWidgetAreaItemBase)widget), (IMaxActions)((Object)widget));
    }

    @Override
    public boolean supportsMaxActions() {
        return false;
    }

    @Override
    public boolean isSneaking() {
        return this.sneaking;
    }

    public void setSneaking(boolean sneaking) {
        this.sneaking = sneaking;
    }

    @Override
    public IBlockRightClicker.RightClickType getClickType() {
        return this.clickType;
    }

    public void setClickType(IBlockRightClicker.RightClickType clickType) {
        this.clickType = clickType;
    }

    public Direction getClickSide() {
        return this.clickSide;
    }

    public void setClickSide(Direction clickSide) {
        this.clickSide = clickSide;
    }

    @Override
    public void getTooltip(List<Component> curTooltip) {
        super.getTooltip(curTooltip);
        curTooltip.add((Component)Component.translatable((String)"pneumaticcraft.gui.progWidget.blockRightClick.clickSide").append(": " + ClientUtils.translateDirection(this.clickSide)));
        if (this.sneaking) {
            curTooltip.add((Component)Component.translatable((String)"pneumaticcraft.gui.progWidget.blockRightClick.sneaking"));
        }
        curTooltip.add((Component)Component.translatable((String)"pneumaticcraft.gui.progWidget.blockRightClick.operation").append(": ").append((Component)Component.translatable((String)this.clickType.getTranslationKey())));
    }

    @Override
    public void setSides(boolean[] sides) {
        this.clickSide = ISidedWidget.getDirForSides(sides);
    }

    @Override
    public boolean[] getSides() {
        return ISidedWidget.getSidesFromDir(this.clickSide);
    }

    @Override
    public IProgWidget copyWidget() {
        return new ProgWidgetBlockRightClick(this.getPosition(), this.digPlaceFields, this.clickSide, this.sneaking, this.clickType);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProgWidgetBlockRightClick that = (ProgWidgetBlockRightClick)o;
        return this.baseEquals(that) && this.sneaking == that.sneaking && this.clickSide == that.clickSide && this.clickType == that.clickType;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.baseHashCode(), this.clickSide, this.sneaking, this.clickType);
    }
}

