/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.entity.drone;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerItem;
import me.desht.pneumaticcraft.api.upgrade.PNCUpgrade;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.entity.drone.DroneEntity;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSpawnParticle;
import me.desht.pneumaticcraft.common.registry.ModEntityTypes;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.common.upgrades.UpgradableItemUtils;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.joml.Vector3f;

public class AmadroneEntity
extends DroneEntity {
    private static ItemStack amadroneStack = ItemStack.EMPTY;
    private static final Vector3f VECTOR3F_ONE = new Vector3f(1.0f, 1.0f, 1.0f);
    private ResourceLocation handlingOffer;
    private int offerTimes;
    private ItemStack usedTablet = ItemStack.EMPTY;
    private String buyingPlayer;
    private AmadronAction amadronAction;

    public AmadroneEntity(EntityType<? extends DroneEntity> type, Level world) {
        super(type, world, null);
        this.setCustomName((Component)Component.translatable((String)"pneumaticcraft.drone.amadronDeliveryDrone"));
    }

    public static AmadroneEntity makeAmadrone(Level world, BlockPos pos) {
        AmadroneEntity drone = new AmadroneEntity((EntityType<? extends DroneEntity>)ModEntityTypes.AMADRONE.get(), world);
        drone.readFromItemStack(AmadroneEntity.getAmadroneStack());
        List offsets = (List)ConfigHelper.common().amadron.amadroneSpawnLocation.get();
        if (offsets.size() != 3) {
            Log.error("invalid offsets for amadron_spawn_location; expecting list of 3 integers! Defaulting to (30, 30, 0)", new Object[0]);
            offsets = ImmutableList.of((Object)30, (Object)30, (Object)0);
        }
        int xOff = (Integer)offsets.get(0);
        int yOff = (Integer)offsets.get(1);
        int zOff = (Integer)offsets.get(2);
        int startY = (Boolean)ConfigHelper.common().amadron.amadroneSpawnLocationRelativeToGroundLevel.get() != false ? world.getHeightmapPos(Heightmap.Types.WORLD_SURFACE, pos.offset(xOff, 0, zOff)).getY() + yOff : pos.getY() + yOff;
        drone.setPos(pos.getX() + xOff, startY, pos.getZ() + zOff);
        return drone;
    }

    private static ItemStack getAmadroneStack() {
        if (amadroneStack.isEmpty()) {
            amadroneStack = new ItemStack((ItemLike)ModItems.DRONE.get());
            ItemStackHandler upgradeInv = new ItemStackHandler(9);
            upgradeInv.setStackInSlot(0, ModUpgrades.SPEED.get().getItemStack(10));
            upgradeInv.setStackInSlot(1, ModUpgrades.INVENTORY.get().getItemStack(35));
            upgradeInv.setStackInSlot(2, ModUpgrades.ITEM_LIFE.get().getItemStack(10));
            upgradeInv.setStackInSlot(3, ModUpgrades.SECURITY.get().getItemStack());
            UpgradableItemUtils.setUpgrades(amadroneStack, (IItemHandler)upgradeInv);
            ((IAirHandlerItem)amadroneStack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM)).addAir(100000);
        }
        return amadroneStack;
    }

    public void setHandlingOffer(ResourceLocation offerId, int times, @Nonnull ItemStack usedTablet, String buyingPlayer, AmadronAction amadronAction) {
        this.handlingOffer = offerId;
        this.offerTimes = times;
        this.usedTablet = usedTablet.copy();
        this.buyingPlayer = buyingPlayer;
        this.amadronAction = amadronAction;
    }

    public ResourceLocation getHandlingOffer() {
        return this.handlingOffer;
    }

    public AmadronAction getAmadronAction() {
        return this.amadronAction;
    }

    public int getOfferTimes() {
        return this.offerTimes;
    }

    public ItemStack getUsedTablet() {
        return this.usedTablet;
    }

    public String getBuyingPlayer() {
        return this.buyingPlayer;
    }

    @Override
    public boolean shouldDropAsItem() {
        return false;
    }

    public boolean shouldDropExperience() {
        return false;
    }

    @Override
    protected void dropEquipment() {
    }

    @Override
    public int getUpgrades(PNCUpgrade upgrade) {
        if (ModUpgrades.SECURITY.get() == upgrade) {
            return 1;
        }
        if (ModUpgrades.ITEM_LIFE.get() == upgrade || ModUpgrades.SPEED.get() == upgrade) {
            return 10;
        }
        if (ModUpgrades.INVENTORY.get() == upgrade) {
            return 35;
        }
        return 0;
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        if (this.handlingOffer != null) {
            CompoundTag subTag = new CompoundTag();
            subTag.putString("offerId", this.handlingOffer.toString());
            subTag.putInt("offerTimes", this.offerTimes);
            subTag.putString("buyingPlayer", this.buyingPlayer);
            if (!this.usedTablet.isEmpty()) {
                subTag.put("usedTablet", this.usedTablet.save((HolderLookup.Provider)this.registryAccess()));
            }
            subTag.putString("amadronAction", this.amadronAction.toString());
            tag.put("amadron", (Tag)subTag);
        }
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("amadron")) {
            CompoundTag subTag = tag.getCompound("amadron");
            this.handlingOffer = ResourceLocation.parse((String)subTag.getString("offerId"));
            this.usedTablet = ItemStack.parseOptional((HolderLookup.Provider)this.registryAccess(), (CompoundTag)subTag.getCompound("usedTablet"));
            this.offerTimes = subTag.getInt("offerTimes");
            this.buyingPlayer = subTag.getString("buyingPlayer");
            this.amadronAction = AmadronAction.valueOf(subTag.getString("amadronAction"));
        }
    }

    @Override
    public boolean isTeleportRangeLimited() {
        return false;
    }

    @Override
    public void overload(String msgKey, Object ... params) {
        NetworkHandler.sendToAllTracking((CustomPacketPayload)new PacketSpawnParticle((ParticleOptions)ParticleTypes.CLOUD, this.getDronePos().toVector3f().add(-0.5f, -0.5f, -0.5f), new Vector3f(0.0f, 0.1f, 0.0f), 10, Optional.of(VECTOR3F_ONE)), (Entity)this);
        this.discard();
    }

    public static enum AmadronAction {
        TAKING_PAYMENT,
        RESTOCKING;

    }
}

