/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.entity.projectile;

import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.entity.drone.DroneEntity;
import me.desht.pneumaticcraft.common.item.MicromissilesItem;
import me.desht.pneumaticcraft.common.particle.AirParticleData;
import me.desht.pneumaticcraft.common.registry.ModDataComponents;
import me.desht.pneumaticcraft.common.registry.ModEntityTypes;
import me.desht.pneumaticcraft.common.util.EntityFilter;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class MicromissileEntity
extends ThrowableProjectile {
    private static final double SEEK_RANGE = 24.0;
    private static final EntityDataAccessor<Integer> TARGET_ID = SynchedEntityData.defineId(MicromissileEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> MAX_VEL_SQ = SynchedEntityData.defineId(MicromissileEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> ACCEL = SynchedEntityData.defineId(MicromissileEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> TURN_SPEED = SynchedEntityData.defineId(MicromissileEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private Entity targetEntity = null;
    private float maxVelocitySq = 0.5f;
    private float accel = 1.05f;
    private float turnSpeed = 0.1f;
    private float explosionPower = 2.0f;
    private EntityFilter entityFilter;
    private boolean outOfFuel = false;
    private MicromissilesItem.FireMode fireMode = MicromissilesItem.FireMode.SMART;

    public MicromissileEntity(EntityType<MicromissileEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public MicromissileEntity(Level worldIn, LivingEntity thrower, ItemStack stack) {
        super(ModEntityTypes.MICROMISSILE.get(), thrower, worldIn);
        MicromissilesItem.Settings settings = (MicromissilesItem.Settings)stack.get(ModDataComponents.MICROMISSILE_SETTINGS);
        if (settings != null) {
            this.entityFilter = EntityFilter.fromString(settings.entityFilter());
            this.fireMode = settings.fireMode();
            switch (this.fireMode) {
                case SMART: {
                    this.accel = Math.max(1.02f, 1.0f + settings.topSpeed() / 10.0f);
                    this.maxVelocitySq = (float)Math.pow(0.25 + (double)(settings.topSpeed() * 3.75f), 2.0);
                    this.turnSpeed = 0.4f * settings.turnSpeed();
                    this.explosionPower = Math.max(1.0f, 5.0f * settings.damage());
                    break;
                }
                case DUMB: {
                    this.accel = 1.5f;
                    this.maxVelocitySq = 6.25f;
                    this.turnSpeed = 0.0f;
                    this.explosionPower = 3.0f;
                }
            }
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(TARGET_ID, (Object)0);
        builder.define(MAX_VEL_SQ, (Object)Float.valueOf(0.5f));
        builder.define(ACCEL, (Object)Float.valueOf(1.05f));
        builder.define(TURN_SPEED, (Object)Float.valueOf(0.4f));
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        if (this.getCommandSenderWorld().isClientSide) {
            if (key.equals(MAX_VEL_SQ)) {
                this.maxVelocitySq = ((Float)this.entityData.get(MAX_VEL_SQ)).floatValue();
            } else if (key.equals(TARGET_ID)) {
                int id = (Integer)this.entityData.get(TARGET_ID);
                this.targetEntity = id > 0 ? this.getCommandSenderWorld().getEntity(((Integer)this.entityData.get(TARGET_ID)).intValue()) : null;
            } else if (key.equals(ACCEL)) {
                this.accel = ((Float)this.entityData.get(ACCEL)).floatValue();
            } else if (key.equals(TURN_SPEED)) {
                this.turnSpeed = ((Float)this.entityData.get(TURN_SPEED)).floatValue();
            }
        }
    }

    public void tick() {
        super.tick();
        if (this.tickCount == 1) {
            if (this.getCommandSenderWorld().isClientSide) {
                this.getCommandSenderWorld().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.FIREWORK_ROCKET_LAUNCH, SoundSource.PLAYERS, 1.0f, 0.8f, true);
            } else {
                this.entityData.set(MAX_VEL_SQ, (Object)Float.valueOf(this.maxVelocitySq));
                this.entityData.set(ACCEL, (Object)Float.valueOf(this.accel));
                this.entityData.set(TURN_SPEED, (Object)Float.valueOf(this.turnSpeed));
            }
        } else if (this.tickCount > (Integer)ConfigHelper.common().micromissiles.lifetime.get()) {
            this.outOfFuel = true;
            if (this.tickCount > (Integer)ConfigHelper.common().micromissiles.maxLifetime.get()) {
                this.explode(null);
            }
        }
        if (!this.outOfFuel) {
            double velSq;
            if (this.isInWater()) {
                this.setDeltaMovement(this.getDeltaMovement().scale(1.25));
            } else {
                this.setDeltaMovement(this.getDeltaMovement().scale(1.0101010101010102));
            }
            if (!(this.targetEntity != null && this.targetEntity.isAlive() || this.fireMode != MicromissilesItem.FireMode.SMART || this.getCommandSenderWorld().isClientSide || (this.tickCount & 3) != 0)) {
                this.targetEntity = this.tryFindNewTarget();
            }
            if (this.targetEntity != null) {
                Vec3 diff = this.targetEntity.position().add(0.0, (double)this.targetEntity.getEyeHeight(), 0.0).subtract(this.position()).normalize().scale((double)this.turnSpeed);
                this.setDeltaMovement(this.getDeltaMovement().add(diff));
            }
            double mul = (velSq = this.getDeltaMovement().lengthSqr()) > (double)this.maxVelocitySq ? (double)this.maxVelocitySq / velSq : (double)this.accel;
            this.setDeltaMovement(this.getDeltaMovement().scale(mul));
            if (this.getCommandSenderWorld().isClientSide && this.getCommandSenderWorld().random.nextBoolean()) {
                Vec3 m = this.getDeltaMovement();
                this.level().addParticle((ParticleOptions)AirParticleData.DENSE, this.getX(), this.getY(), this.getZ(), -m.x / 2.0, -m.y / 2.0, -m.z / 2.0);
            }
        }
    }

    private Entity tryFindNewTarget() {
        AABB aabb = new AABB(this.getX(), this.getY(), this.getZ(), this.getX(), this.getY(), this.getZ()).inflate(24.0);
        List l = this.getCommandSenderWorld().getEntitiesOfClass(LivingEntity.class, aabb, EntitySelector.ENTITY_STILL_ALIVE);
        l.sort(new TargetSorter(this));
        Entity tgt = null;
        for (Entity e : l) {
            if (!this.isValidTarget(e) || !(e.distanceToSqr((Entity)this) < 576.0)) continue;
            ClipContext ctx = new ClipContext(this.position(), e.position().add(0.0, (double)e.getEyeHeight(), 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, e);
            BlockHitResult res = this.getCommandSenderWorld().clip(ctx);
            if (res.getType() != HitResult.Type.MISS && res.getType() != HitResult.Type.ENTITY) continue;
            tgt = e;
            break;
        }
        this.entityData.set(TARGET_ID, (Object)(tgt == null ? 0 : tgt.getId()));
        return tgt;
    }

    public boolean isValidTarget(Entity e) {
        Entity thrower = this.getOwner();
        if (thrower != null) {
            Horse h;
            DroneEntity d;
            TamableAnimal t;
            UUID throwerID = thrower.getUUID();
            if (thrower.equals((Object)e) || e instanceof TamableAnimal && throwerID.equals((t = (TamableAnimal)e).getOwnerUUID()) || e instanceof DroneEntity && throwerID.equals((d = (DroneEntity)e).getOwnerUUID()) || e instanceof Horse && throwerID.equals((h = (Horse)e).getOwnerUUID())) {
                return false;
            }
        }
        if (this.entityFilter != null && !this.entityFilter.test(e)) {
            return false;
        }
        return e instanceof LivingEntity || e instanceof Boat || e instanceof AbstractMinecart;
    }

    protected void onHit(HitResult result) {
        if (this.tickCount > 5 && !this.getCommandSenderWorld().isClientSide && this.isAlive()) {
            this.explode(result instanceof EntityHitResult ? ((EntityHitResult)result).getEntity() : null);
        }
    }

    private void explode(Entity e) {
        double z;
        double y;
        double x;
        this.discard();
        Level.ExplosionInteraction mode = (Boolean)ConfigHelper.common().micromissiles.damageTerrain.get() != false ? Level.ExplosionInteraction.TNT : Level.ExplosionInteraction.NONE;
        boolean fire = (Boolean)ConfigHelper.common().micromissiles.startFires.get();
        float radius = ((Double)ConfigHelper.common().micromissiles.baseExplosionDamage.get()).floatValue() * this.explosionPower;
        if (e == null) {
            x = this.getX();
            y = this.getY();
            z = this.getZ();
        } else {
            x = Mth.lerp((double)0.25, (double)e.getX(), (double)this.getX());
            y = Mth.lerp((double)0.25, (double)e.getY(), (double)this.getY());
            z = Mth.lerp((double)0.25, (double)e.getZ(), (double)this.getZ());
        }
        this.getCommandSenderWorld().explode((Entity)this, x, y, z, radius, fire, mode);
    }

    public void shootFromRotation(Entity entityThrower, float pitch, float yaw, float pitchOffset, float velocity, float inaccuracy) {
        float x = -Mth.sin((float)(yaw * ((float)Math.PI / 180))) * Mth.cos((float)(pitch * ((float)Math.PI / 180)));
        float y = -Mth.sin((float)(pitch * ((float)Math.PI / 180)));
        float z = Mth.cos((float)(yaw * ((float)Math.PI / 180))) * Mth.cos((float)(pitch * ((float)Math.PI / 180)));
        this.shoot(x, y, z, velocity, 0.0f);
        this.setDeltaMovement(this.getDeltaMovement().add(entityThrower.getDeltaMovement().x, 0.0, entityThrower.getDeltaMovement().z));
    }

    public void shoot(double x, double y, double z, float velocity, float inaccuracy) {
        double f = Math.sqrt(x * x + y * y + z * z);
        x = x / f * (double)velocity;
        y = y / f * (double)velocity;
        z = z / f * (double)velocity;
        this.setDeltaMovement(x, y, z);
        float f1 = Mth.sqrt((float)((float)(x * x + z * z)));
        this.setYRot((float)(Mth.atan2((double)x, (double)z) * 57.29577951308232));
        this.setXRot((float)(Mth.atan2((double)y, (double)f1) * 57.29577951308232));
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
    }

    public boolean isNoGravity() {
        return !this.outOfFuel;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putFloat("turnSpeed", this.turnSpeed);
        compound.putFloat("explosionScaling", this.explosionPower);
        compound.putFloat("topSpeedSq", this.maxVelocitySq);
        compound.putString("filter", this.entityFilter.toString());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.turnSpeed = compound.getFloat("turnSpeed");
        this.explosionPower = compound.getFloat("explosionScaling");
        this.maxVelocitySq = compound.getFloat("topSpeedSq");
        this.entityFilter = EntityFilter.fromString(compound.getString("filter"));
    }

    public void setTarget(Entity target) {
        this.targetEntity = target;
    }

    private class TargetSorter
    implements Comparator<Entity> {
        private final Vec3 vec;

        TargetSorter(MicromissileEntity micromissileEntity) {
            this.vec = micromissileEntity.position();
        }

        @Override
        public int compare(Entity e1, Entity e2) {
            return Double.compare(this.vec.distanceToSqr(e1.position()), this.vec.distanceToSqr(e2.position()));
        }
    }
}

