/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.heat;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;

public class HeatExtractionTracker
extends SavedData {
    private static final String DATA_NAME = "PneumaticCraftHeatExtraction";
    private final Map<BlockPos, Double> extracted = new HashMap<BlockPos, Double>();

    public static SavedData.Factory<HeatExtractionTracker> factory() {
        return new SavedData.Factory(HeatExtractionTracker::new, HeatExtractionTracker::load, null);
    }

    private HeatExtractionTracker() {
    }

    private static HeatExtractionTracker load(CompoundTag tag, HolderLookup.Provider provider) {
        return new HeatExtractionTracker().readNBT(tag);
    }

    public static HeatExtractionTracker getInstance(Level world) {
        return (HeatExtractionTracker)((ServerLevel)world).getDataStorage().computeIfAbsent(HeatExtractionTracker.factory(), DATA_NAME);
    }

    public double getHeatExtracted(BlockPos pos) {
        return this.extracted.getOrDefault(pos, 0.0);
    }

    public void extractHeat(BlockPos pos, double heat) {
        double newAmount = this.getHeatExtracted(pos) + heat;
        if (Math.abs(newAmount) < 1.0E-6) {
            this.extracted.remove(pos);
        } else {
            this.extracted.put(pos, newAmount);
        }
        this.setDirty();
    }

    private HeatExtractionTracker readNBT(CompoundTag nbt) {
        this.extracted.clear();
        ListTag list = nbt.getList("extracted", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag sub = list.getCompound(i);
            NbtUtils.readBlockPos((CompoundTag)sub, (String)"pos").ifPresent(pos -> this.extracted.put((BlockPos)pos, sub.getDouble("heat")));
        }
        return this;
    }

    public CompoundTag save(CompoundTag compound, HolderLookup.Provider provider) {
        ListTag list = new ListTag();
        this.extracted.forEach((pos, heat) -> {
            CompoundTag sub = new CompoundTag();
            sub.put("pos", NbtUtils.writeBlockPos((BlockPos)pos));
            sub.putDouble("heat", heat.doubleValue());
            list.add((Object)sub);
        });
        compound.put("extracted", (Tag)list);
        return compound;
    }
}

