/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.item.IPositionProvider;
import me.desht.pneumaticcraft.common.amadron.ImmutableBasket;
import me.desht.pneumaticcraft.common.amadron.ShoppingBasket;
import me.desht.pneumaticcraft.common.block.entity.utility.ChargingStationBlockEntity;
import me.desht.pneumaticcraft.common.inventory.AmadronMenu;
import me.desht.pneumaticcraft.common.item.IChargeableContainerProvider;
import me.desht.pneumaticcraft.common.item.PressurizableItem;
import me.desht.pneumaticcraft.common.registry.ModDataComponents;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.registry.ModMenuTypes;
import me.desht.pneumaticcraft.common.registry.ModSounds;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.GlobalPosHelper;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class AmadronTabletItem
extends PressurizableItem
implements IPositionProvider,
IChargeableContainerProvider {
    public AmadronTabletItem() {
        super(ModItems.toolProps().component(ModDataComponents.AMADRON_SHOPPING_BASKET, (Object)ShoppingBasket.empty()), 30000, 3000);
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        if (playerIn instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)playerIn;
            AmadronTabletItem.openGui(sp, handIn);
        }
        return InteractionResultHolder.sidedSuccess((Object)playerIn.getItemInHand(handIn), (boolean)playerIn.level().isClientSide);
    }

    public InteractionResult useOn(UseOnContext ctx) {
        BlockPos pos;
        Direction facing = ctx.getClickedFace();
        Player player = ctx.getPlayer();
        Level worldIn = ctx.getLevel();
        BlockEntity te = worldIn.getBlockEntity(pos = ctx.getClickedPos());
        if (te == null || player == null) {
            return InteractionResult.PASS;
        }
        if (IOHelper.getFluidHandlerForBlock(te, facing).isPresent()) {
            if (!worldIn.isClientSide) {
                AmadronTabletItem.setFluidProvidingLocation(player.getItemInHand(ctx.getHand()), GlobalPosHelper.makeGlobalPos(worldIn, pos));
            } else {
                player.playSound((SoundEvent)ModSounds.CHIRP.get(), 1.0f, 1.5f);
            }
        } else if (IOHelper.getInventoryForBlock(te, facing).isPresent()) {
            if (!worldIn.isClientSide) {
                AmadronTabletItem.setItemProvidingLocation(player.getItemInHand(ctx.getHand()), GlobalPosHelper.makeGlobalPos(worldIn, pos));
            } else {
                player.playSound((SoundEvent)ModSounds.CHIRP.get(), 1.0f, 1.5f);
            }
        } else {
            return InteractionResult.PASS;
        }
        return InteractionResult.SUCCESS;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> infoList, TooltipFlag flag) {
        super.appendHoverText(stack, context, infoList, flag);
        GlobalPos gPos = AmadronTabletItem.getItemProvidingLocation(stack);
        if (gPos != null) {
            infoList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.amadronTablet.itemLocation", GlobalPosHelper.prettyPrint(gPos)).withStyle(ChatFormatting.YELLOW));
        } else {
            infoList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.amadronTablet.selectItemLocation", new Object[0]));
        }
        gPos = AmadronTabletItem.getFluidProvidingLocation(stack);
        if (gPos != null) {
            infoList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.amadronTablet.fluidLocation", GlobalPosHelper.prettyPrint(gPos)).withStyle(ChatFormatting.YELLOW));
        } else {
            infoList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.amadronTablet.selectFluidLocation", new Object[0]));
        }
    }

    public static Optional<IItemHandler> getItemCapability(ItemStack tablet) {
        GlobalPos pos = AmadronTabletItem.getItemProvidingLocation(tablet);
        if (pos != null) {
            BlockEntity te = GlobalPosHelper.getTileEntity(pos);
            for (Direction dir : DirectionUtil.VALUES) {
                Optional<IItemHandler> cap = IOHelper.getInventoryForBlock(te, dir);
                if (!cap.isPresent()) continue;
                return cap;
            }
        }
        return Optional.empty();
    }

    public static GlobalPos getItemProvidingLocation(ItemStack tablet) {
        return (GlobalPos)tablet.get(ModDataComponents.AMADRON_ITEM_POS);
    }

    private static void setItemProvidingLocation(ItemStack tablet, GlobalPos globalPos) {
        if (globalPos == null) {
            tablet.remove(ModDataComponents.AMADRON_ITEM_POS);
        } else {
            tablet.set(ModDataComponents.AMADRON_ITEM_POS, (Object)globalPos);
        }
    }

    public static Optional<IFluidHandler> getFluidCapability(ItemStack tablet) {
        GlobalPos pos = AmadronTabletItem.getFluidProvidingLocation(tablet);
        if (pos != null) {
            BlockEntity te = GlobalPosHelper.getTileEntity(pos);
            for (Direction dir : DirectionUtil.VALUES) {
                Optional<IFluidHandler> cap = IOHelper.getFluidHandlerForBlock(te, dir);
                if (!cap.isPresent()) continue;
                return cap;
            }
        }
        return Optional.empty();
    }

    public static GlobalPos getFluidProvidingLocation(ItemStack tablet) {
        return (GlobalPos)tablet.get(ModDataComponents.AMADRON_FLUID_POS);
    }

    private static void setFluidProvidingLocation(ItemStack tablet, GlobalPos globalPos) {
        if (globalPos == null) {
            tablet.remove(ModDataComponents.AMADRON_FLUID_POS);
        } else {
            tablet.set(ModDataComponents.AMADRON_FLUID_POS, (Object)globalPos);
        }
    }

    @Nonnull
    public static ImmutableBasket loadShoppingCart(ItemStack tablet) {
        return (ImmutableBasket)tablet.getOrDefault(ModDataComponents.AMADRON_SHOPPING_BASKET, (Object)ShoppingBasket.empty());
    }

    public static void saveShoppingCart(ItemStack tablet, ShoppingBasket basket) {
        tablet.set(ModDataComponents.AMADRON_SHOPPING_BASKET, (Object)basket.toImmutable());
    }

    @Override
    @NotNull
    public List<BlockPos> getStoredPositions(UUID playerId, @NotNull ItemStack stack) {
        GlobalPos gp1 = AmadronTabletItem.getItemProvidingLocation(stack);
        GlobalPos gp2 = AmadronTabletItem.getFluidProvidingLocation(stack);
        return Arrays.asList(gp1 == null ? null : gp1.pos(), gp2 == null ? null : gp2.pos());
    }

    @Override
    public int getRenderColor(int index) {
        return switch (index) {
            case 0 -> -1868543730;
            case 1 -> -1878998848;
            default -> -1;
        };
    }

    public static void openGui(final ServerPlayer playerIn, final InteractionHand handIn) {
        playerIn.openMenu(new MenuProvider(){

            public Component getDisplayName() {
                return playerIn.getItemInHand(handIn).getHoverName();
            }

            public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player playerEntity) {
                return new AmadronMenu(windowId, playerInventory, handIn);
            }
        }, buf -> buf.writeBoolean(handIn == InteractionHand.MAIN_HAND));
    }

    @Override
    public MenuProvider getContainerProvider(ChargingStationBlockEntity te) {
        return new IChargeableContainerProvider.Provider(te, ModMenuTypes.CHARGING_AMADRON.get());
    }
}

