/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.pneumatic_armor.hacking.IHackableBlock;
import me.desht.pneumaticcraft.common.hacking.HackManager;
import me.desht.pneumaticcraft.common.hacking.HackTickTracker;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonUpgradeHandlers;
import me.desht.pneumaticcraft.common.registry.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketHackingBlockFinish(BlockPos pos) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PacketHackingBlockFinish> TYPE = new CustomPacketPayload.Type(PneumaticRegistry.RL("hack_block_finish"));
    public static final StreamCodec<FriendlyByteBuf, PacketHackingBlockFinish> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, PacketHackingBlockFinish::pos, PacketHackingBlockFinish::new);

    public static PacketHackingBlockFinish create(BlockPos gPos) {
        return new PacketHackingBlockFinish(gPos);
    }

    public CustomPacketPayload.Type<PacketHackingBlockFinish> type() {
        return TYPE;
    }

    public static void handle(PacketHackingBlockFinish message, IPayloadContext ctx) {
        Player player = ctx.player();
        IHackableBlock hackableBlock = HackManager.getHackableForBlock(player.level(), message.pos(), player);
        if (hackableBlock != null) {
            hackableBlock.onHackComplete(player.level(), message.pos(), player);
            HackTickTracker.getInstance(player.level()).trackBlock(message.pos(), hackableBlock);
            CommonArmorHandler.getHandlerForPlayer(player).getExtensionData(CommonUpgradeHandlers.hackHandler).setHackedBlockPos(null);
            player.playSound((SoundEvent)ModSounds.HELMET_HACK_FINISH.get(), 1.0f, 1.0f);
        }
    }
}

