/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.Comparator;
import java.util.List;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSetEntityMotion;
import me.desht.pneumaticcraft.common.network.PacketSpawnParticle;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonUpgradeHandlers;
import me.desht.pneumaticcraft.common.registry.ModSounds;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.joml.Vector3f;

public enum PacketPneumaticKick implements CustomPacketPayload
{
    INSTANCE;

    public static final CustomPacketPayload.Type<PacketPneumaticKick> TYPE;
    public static final StreamCodec<FriendlyByteBuf, PacketPneumaticKick> STREAM_CODEC;
    private static final Vector3f PARTICLE_SPEED;

    public CustomPacketPayload.Type<PacketPneumaticKick> type() {
        return TYPE;
    }

    public static void handle(PacketPneumaticKick message, IPayloadContext ctx) {
        int upgrades;
        CommonArmorHandler handler = CommonArmorHandler.getHandlerForPlayer(ctx.player());
        if (handler.upgradeUsable(CommonUpgradeHandlers.kickHandler, false) && (upgrades = handler.getUpgradeCount(EquipmentSlot.FEET, ModUpgrades.DISPENSER.get())) > 0) {
            message.handleKick(ctx.player(), Math.min(4, upgrades));
        }
    }

    private void handleKick(Player player, int upgrades) {
        Vec3 lookVec = new Vec3(player.getLookAngle().x, Math.max(0.0, player.getLookAngle().y), player.getLookAngle().z).normalize();
        double playerFootY = player.getY() - (double)(player.getBbHeight() / 2.0f);
        AABB box = new AABB(player.getX(), playerFootY, player.getZ(), player.getX(), playerFootY, player.getZ()).inflate(1.5, 1.5, 1.5).move(lookVec);
        List entities = player.level().getEntities((Entity)player, box);
        if (entities.isEmpty()) {
            return;
        }
        entities.sort(Comparator.comparingDouble(o -> o.distanceToSqr((Entity)player)));
        Entity target = (Entity)entities.get(0);
        if (!target.skipAttackInteraction((Entity)player)) {
            if (target instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)target;
                target.hurt(target.damageSources().playerAttack(player), 3.0f + (float)upgrades * 0.5f);
                living.setJumping(true);
            }
            target.setOnGround(false);
            target.horizontalCollision = false;
            target.verticalCollision = false;
            target.setDeltaMovement(target.getDeltaMovement().add(lookVec.scale(1.0 + (double)upgrades * 0.5)).add(0.0, (double)upgrades * 0.1, 0.0));
        }
        player.level().playSound(null, target.getX(), target.getY(), target.getZ(), (SoundEvent)ModSounds.PUNCH.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        NetworkHandler.sendToAllTracking((CustomPacketPayload)PacketSetEntityMotion.create(target, target.getDeltaMovement()), target);
        NetworkHandler.sendToAllTracking((CustomPacketPayload)PacketSpawnParticle.oneParticle((ParticleOptions)ParticleTypes.EXPLOSION, target.position().toVector3f(), PARTICLE_SPEED), target);
        CommonArmorHandler.getHandlerForPlayer(player).addAir(EquipmentSlot.FEET, -150 * upgrades);
    }

    static {
        TYPE = new CustomPacketPayload.Type(PneumaticRegistry.RL("pneumatic_kick"));
        STREAM_CODEC = StreamCodec.unit((Object)((Object)INSTANCE));
        PARTICLE_SPEED = new Vector3f(1.0f, 0.0f, 0.0f);
    }
}

