/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.joml.Vector3f;

public record PacketSpawnIndicatorParticles(BlockPos pos0, DyeColor dyeColor, List<ByteOffset> offsets) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PacketSpawnIndicatorParticles> TYPE = new CustomPacketPayload.Type(PneumaticRegistry.RL("indicator_particles"));
    public static final StreamCodec<FriendlyByteBuf, PacketSpawnIndicatorParticles> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, PacketSpawnIndicatorParticles::pos0, (StreamCodec)NeoForgeStreamCodecs.enumCodec(DyeColor.class), PacketSpawnIndicatorParticles::dyeColor, (StreamCodec)ByteOffset.STREAM_CODEC.apply(ByteBufCodecs.list()), PacketSpawnIndicatorParticles::offsets, PacketSpawnIndicatorParticles::new);

    public static PacketSpawnIndicatorParticles create(List<BlockPos> posList, DyeColor dyeColor) {
        BlockPos pos0 = posList.get(0);
        ArrayList<ByteOffset> offsets = new ArrayList<ByteOffset>();
        for (int i = 1; i < posList.size(); ++i) {
            BlockPos off = posList.get(i).subtract((Vec3i)pos0);
            if (off.getX() < -128 || off.getX() > 127 || off.getY() < -128 || off.getY() > 127 || off.getZ() < -128 || off.getZ() > 127) continue;
            offsets.add(new ByteOffset(off.getX(), off.getY(), off.getZ()));
        }
        return new PacketSpawnIndicatorParticles(pos0, dyeColor, offsets);
    }

    public CustomPacketPayload.Type<PacketSpawnIndicatorParticles> type() {
        return TYPE;
    }

    public static void handle(PacketSpawnIndicatorParticles message, IPayloadContext ctx) {
        Level world = ctx.player().level();
        float[] cols = RenderUtils.decomposeColorF(message.dyeColor().getTextureDiffuseColor());
        DustParticleOptions particle = new DustParticleOptions(new Vector3f(cols[0], cols[1], cols[2]), 1.0f);
        BlockPos pos0 = message.pos0();
        world.addParticle((ParticleOptions)particle, (double)pos0.getX() + 0.5, (double)pos0.getY() + 0.5, (double)pos0.getZ() + 0.5, 0.0, 0.0, 0.0);
        for (ByteOffset offset : message.offsets()) {
            world.addParticle((ParticleOptions)particle, (double)(pos0.getX() + offset.x) + 0.5, (double)(pos0.getY() + offset.y) + 0.5, (double)(pos0.getZ() + offset.z) + 0.5, 0.0, 0.0, 0.0);
        }
    }

    private record ByteOffset(byte x, byte y, byte z) {
        public static final StreamCodec<FriendlyByteBuf, ByteOffset> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BYTE, ByteOffset::x, (StreamCodec)ByteBufCodecs.BYTE, ByteOffset::y, (StreamCodec)ByteBufCodecs.BYTE, ByteOffset::z, ByteOffset::new);

        public ByteOffset(int x, int y, int z) {
            this((byte)x, (byte)y, (byte)z);
        }
    }
}

