/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.semiblock.ISemiBlock;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.semiblock.ISyncableSemiblockItem;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.Util;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.connection.ConnectionType;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.apache.commons.lang3.Validate;

public record PacketSyncSemiblock(int entityID, RegistryFriendlyByteBuf payload) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PacketSyncSemiblock> TYPE = new CustomPacketPayload.Type(PneumaticRegistry.RL("sync_semiblock"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketSyncSemiblock> STREAM_CODEC = StreamCodec.of(PacketSyncSemiblock::write, PacketSyncSemiblock::fromNetwork);

    public static PacketSyncSemiblock create(ISemiBlock semiBlock, boolean itemContainer, RegistryAccess registryAccess) {
        RegistryFriendlyByteBuf payload = (RegistryFriendlyByteBuf)Util.make((Object)new RegistryFriendlyByteBuf(Unpooled.buffer(), registryAccess, ConnectionType.NEOFORGE), semiBlock::writeToBuf);
        return new PacketSyncSemiblock(itemContainer ? -1 : semiBlock.getTrackingId(), payload);
    }

    private static void write(RegistryFriendlyByteBuf buffer, PacketSyncSemiblock message) {
        buffer.writeInt(message.entityID);
        int size = message.payload.writerIndex();
        buffer.writeVarInt(size);
        buffer.writeBytes((ByteBuf)message.payload, 0, size);
    }

    private static PacketSyncSemiblock fromNetwork(RegistryFriendlyByteBuf buffer) {
        int entityID = buffer.readInt();
        int size = buffer.readVarInt();
        RegistryFriendlyByteBuf payload = new RegistryFriendlyByteBuf(Unpooled.buffer((int)size), buffer.registryAccess(), ConnectionType.NEOFORGE);
        buffer.readBytes((ByteBuf)payload, size);
        return new PacketSyncSemiblock(entityID, payload);
    }

    public CustomPacketPayload.Type<PacketSyncSemiblock> type() {
        return TYPE;
    }

    public static void handle(PacketSyncSemiblock message, IPayloadContext ctx) {
        if (ctx.flow().isClientbound()) {
            message.handleClient();
        } else {
            Player player = ctx.player();
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                message.handleServer(sp);
            }
        }
        message.payload.release();
    }

    private void handleServer(ServerPlayer sender) {
        if (this.entityID == -1) {
            AbstractContainerMenu abstractContainerMenu = sender.containerMenu;
            if (abstractContainerMenu instanceof ISyncableSemiblockItem) {
                ISyncableSemiblockItem syncable = (ISyncableSemiblockItem)abstractContainerMenu;
                syncable.syncSemiblockItemFromClient((Player)sender, this.payload);
            } else {
                Log.warning("PacketSyncSemiblock: received packet with entity id -1, but player is not holding a semiblock item?", new Object[0]);
            }
        } else {
            this.processEntity(sender.level());
        }
    }

    private void handleClient() {
        Validate.isTrue((this.entityID >= 0 ? 1 : 0) != 0);
        this.processEntity(ClientUtils.getClientLevel());
    }

    private void processEntity(Level world) {
        ISemiBlock semiBlock = ISemiBlock.byTrackingId(world, this.entityID);
        if (semiBlock != null) {
            semiBlock.readFromBuf(this.payload);
        } else {
            Log.warning("PacketSyncSemiblock: did not get expected ISemiBlock entity for entity ID {}", this.entityID);
        }
    }
}

