/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorUpgradeHandler;
import me.desht.pneumaticcraft.common.item.PneumaticArmorItem;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.registry.ModDataComponents;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketUpdateArmorExtraData(EquipmentSlot slot, ResourceLocation upgradeID, DataComponentPatch patch) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PacketUpdateArmorExtraData> TYPE = new CustomPacketPayload.Type(PneumaticRegistry.RL("update_armor_extradata"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketUpdateArmorExtraData> STREAM_CODEC = StreamCodec.composite((StreamCodec)NeoForgeStreamCodecs.enumCodec(EquipmentSlot.class), PacketUpdateArmorExtraData::slot, (StreamCodec)ResourceLocation.STREAM_CODEC, PacketUpdateArmorExtraData::upgradeID, (StreamCodec)DataComponentPatch.STREAM_CODEC, PacketUpdateArmorExtraData::patch, PacketUpdateArmorExtraData::new);
    private static final List<Set<DataComponentType<?>>> VALID_KEYS = new ArrayList();

    public static <T> void sendToServer(IArmorUpgradeHandler<?> handler, DataComponentType<T> type, T data) {
        DataComponentPatch patch = DataComponentPatch.builder().set(type, data).build();
        NetworkHandler.sendToServer(new PacketUpdateArmorExtraData(handler.getEquipmentSlot(), handler.getID(), patch));
    }

    private static void addKey(EquipmentSlot slot, DataComponentType<?> type) {
        VALID_KEYS.get(slot.getIndex()).add(type);
    }

    public CustomPacketPayload.Type<PacketUpdateArmorExtraData> type() {
        return TYPE;
    }

    public static void handle(PacketUpdateArmorExtraData message, IPayloadContext ctx) {
        ItemStack stack = ctx.player().getItemBySlot(message.slot());
        if (stack.getItem() instanceof PneumaticArmorItem) {
            CommonArmorHandler handler = CommonArmorHandler.getHandlerForPlayer(ctx.player());
            DataComponentMap dataComponentMap = stack.getComponents();
            if (dataComponentMap instanceof PatchedDataComponentMap) {
                PatchedDataComponentMap pdcm = (PatchedDataComponentMap)dataComponentMap;
                message.patch.entrySet().forEach(entry -> {
                    if (PacketUpdateArmorExtraData.isTypeOKForSlot(message.slot, (DataComponentType)entry.getKey())) {
                        pdcm.applyPatch(message.patch);
                        IArmorUpgradeHandler<?> upgradeHandler = ArmorUpgradeRegistry.getInstance().getUpgradeEntry(message.upgradeID());
                        if (upgradeHandler != null) {
                            ((Optional)entry.getValue()).ifPresent(val -> upgradeHandler.onDataFieldUpdated(handler, (DataComponentType)entry.getKey(), val));
                        }
                    }
                });
            }
        }
    }

    private static boolean isTypeOKForSlot(EquipmentSlot slot, DataComponentType<?> type) {
        return VALID_KEYS.get(slot.getIndex()).contains(type);
    }

    static {
        for (EquipmentSlot ignored : ArmorUpgradeRegistry.ARMOR_SLOTS) {
            VALID_KEYS.add(new HashSet());
        }
        PacketUpdateArmorExtraData.addKey(EquipmentSlot.HEAD, ModDataComponents.ENTITY_FILTER.get());
        PacketUpdateArmorExtraData.addKey(EquipmentSlot.HEAD, ModDataComponents.COORD_TRACKER.get());
        PacketUpdateArmorExtraData.addKey(EquipmentSlot.LEGS, ModDataComponents.SPEED_BOOST_PCT.get());
        PacketUpdateArmorExtraData.addKey(EquipmentSlot.LEGS, ModDataComponents.JET_BOOTS_PCT.get());
        PacketUpdateArmorExtraData.addKey(EquipmentSlot.FEET, ModDataComponents.JET_BOOTS_STABILIZERS.get());
        PacketUpdateArmorExtraData.addKey(EquipmentSlot.FEET, ModDataComponents.JET_BOOTS_BUILDER_MODE.get());
        PacketUpdateArmorExtraData.addKey(EquipmentSlot.FEET, ModDataComponents.JET_BOOTS_HOVER.get());
        PacketUpdateArmorExtraData.addKey(EquipmentSlot.FEET, ModDataComponents.JET_BOOTS_SMART_HOVER.get());
    }
}

