/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.pneumatic_armor.handlers;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.pneumatic_armor.BaseArmorUpgradeHandler;
import me.desht.pneumaticcraft.api.pneumatic_armor.BuiltinArmorUpgrades;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorExtensionData;
import me.desht.pneumaticcraft.api.pneumatic_armor.ICommonArmorHandler;
import me.desht.pneumaticcraft.api.upgrade.PNCUpgrade;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;

public class StepAssistHandler
extends BaseArmorUpgradeHandler<IArmorExtensionData> {
    private static final ResourceLocation STEP_ASSIST_MODIFIER_ID = PneumaticRegistry.RL("step_assist");

    @Override
    public ResourceLocation getID() {
        return BuiltinArmorUpgrades.STEP_ASSIST;
    }

    @Override
    public PNCUpgrade[] getRequiredUpgrades() {
        return new PNCUpgrade[0];
    }

    @Override
    public float getIdleAirUsage(ICommonArmorHandler armorHandler) {
        return 0.0f;
    }

    @Override
    public EquipmentSlot getEquipmentSlot() {
        return EquipmentSlot.FEET;
    }

    @Override
    public void tick(ICommonArmorHandler commonArmorHandler, boolean enabled) {
        Player player = commonArmorHandler.getPlayer();
        AttributeInstance attributeInstance = player.getAttribute(Attributes.STEP_HEIGHT);
        if (attributeInstance != null) {
            double stepBoost;
            AttributeModifier currentModifier = attributeInstance.getModifier(STEP_ASSIST_MODIFIER_ID);
            double d = stepBoost = enabled && commonArmorHandler.hasMinPressure(EquipmentSlot.FEET) && !player.isShiftKeyDown() ? 0.6 : 0.0;
            if (currentModifier != null) {
                if (PneumaticCraftUtils.epsilonEquals(currentModifier.amount(), stepBoost)) {
                    return;
                }
                attributeInstance.removeModifier(currentModifier.id());
            }
            if (stepBoost > 0.0) {
                attributeInstance.addTransientModifier(new AttributeModifier(STEP_ASSIST_MODIFIER_ID, stepBoost, AttributeModifier.Operation.ADD_VALUE));
            }
        }
    }

    @Override
    public void onToggle(ICommonArmorHandler commonArmorHandler, boolean newState) {
        if (!newState) {
            this.onShutdown(commonArmorHandler);
        }
    }

    @Override
    public void onShutdown(ICommonArmorHandler commonArmorHandler) {
        AttributeModifier currentModifier;
        AttributeInstance attributeInstance = commonArmorHandler.getPlayer().getAttribute(Attributes.STEP_HEIGHT);
        if (attributeInstance != null && (currentModifier = attributeInstance.getModifier(STEP_ASSIST_MODIFIER_ID)) != null) {
            attributeInstance.removeModifier(currentModifier.id());
        }
    }
}

