/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.jei;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import me.desht.pneumaticcraft.common.XPFluidManager;
import me.desht.pneumaticcraft.common.registry.ModBlocks;
import me.desht.pneumaticcraft.common.registry.ModFluids;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.thirdparty.jei.AbstractPNCCategory;
import me.desht.pneumaticcraft.common.thirdparty.jei.RecipeTypes;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public class JEIMemoryEssenceCategory
extends AbstractPNCCategory<MemoryEssenceRecipe> {
    public JEIMemoryEssenceCategory() {
        super(RecipeTypes.MEMORY_ESSENCE, new FluidStack((Fluid)ModFluids.MEMORY_ESSENCE.get(), 1000).getHoverName(), (IDrawable)JEIMemoryEssenceCategory.guiHelper().createDrawable(Textures.GUI_JEI_MEMORY_ESSENCE, 0, 0, 146, 73), JEIMemoryEssenceCategory.guiHelper().createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModItems.MEMORY_ESSENCE_BUCKET.get())));
    }

    public void setRecipe(IRecipeLayoutBuilder builder, MemoryEssenceRecipe recipe, IFocusGroup focuses) {
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 54, 29).addItemStack(recipe.input1)).addTooltipCallback((IRecipeSlotTooltipCallback)new Tooltip(recipe, 0));
        if (!recipe.input2.isEmpty()) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 76, 29).addItemStack(recipe.input2)).addTooltipCallback((IRecipeSlotTooltipCallback)new Tooltip(recipe, 1));
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 112, 29).addIngredients((IIngredientType)NeoForgeTypes.FLUID_STACK, Collections.singletonList(new FluidStack((Fluid)ModFluids.MEMORY_ESSENCE.get(), 1000)));
    }

    public void draw(MemoryEssenceRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        Font fr = Minecraft.getInstance().font;
        int ratio = XPFluidManager.getInstance().getXPRatio((Fluid)ModFluids.MEMORY_ESSENCE.get());
        String s = "1 XP = " + ratio + " mB";
        int w = fr.width(s);
        graphics.drawString(fr, s, (this.getBackground().getWidth() - w) / 2, 0, 0x404040, false);
    }

    static List<MemoryEssenceRecipe> getAllRecipes() {
        return ImmutableList.of((Object)new MemoryEssenceRecipe((ItemLike)ModItems.MEMORY_STICK.get(), null), (Object)new MemoryEssenceRecipe((ItemLike)ModBlocks.AERIAL_INTERFACE.get(), (ItemLike)ModUpgrades.DISPENSER.get().getItem()), (Object)new MemoryEssenceRecipe((ItemLike)ModItems.DRONE.get(), (ItemLike)ModItems.PROGRAMMING_PUZZLE.get()).setTooltipKey(1, "pneumaticcraft.gui.jei.tooltip.droneImportOrbs"));
    }

    public static class MemoryEssenceRecipe {
        final ItemStack input1;
        final ItemStack input2;
        final String[] tooltips = new String[]{"", ""};

        public MemoryEssenceRecipe(ItemLike input1, ItemLike input2) {
            this.input1 = new ItemStack(input1);
            this.input2 = input2 == null ? ItemStack.EMPTY : new ItemStack(input2);
        }

        public MemoryEssenceRecipe setTooltipKey(int slot, String tooltipKey) {
            this.tooltips[slot] = tooltipKey;
            return this;
        }

        public String getTooltipKey(int slot) {
            return slot >= 0 && slot <= 2 ? this.tooltips[slot] : "";
        }
    }

    private record Tooltip(MemoryEssenceRecipe recipe, int slot) implements IRecipeSlotTooltipCallback
    {
        public void onTooltip(IRecipeSlotView recipeSlotView, List<Component> tooltip) {
            String tooltipKey = this.recipe.getTooltipKey(this.slot);
            if (!tooltipKey.isEmpty()) {
                tooltip.addAll(PneumaticCraftUtils.splitStringComponent(String.valueOf(ChatFormatting.GREEN) + I18n.get((String)tooltipKey, (Object[])new Object[0])));
            }
        }
    }
}

