/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class GlobalPosHelper {
    public static JsonElement toJson(GlobalPos pos) {
        return (JsonElement)GlobalPos.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)pos).result().orElseThrow();
    }

    public static GlobalPos fromJson(JsonObject json) {
        return (GlobalPos)GlobalPos.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).result().orElseThrow();
    }

    public static ServerLevel getWorldForGlobalPos(GlobalPos pos) {
        return ServerLifecycleHooks.getCurrentServer().getLevel(pos.dimension());
    }

    public static ServerLevel getWorldForGlobalPos(MinecraftServer server, GlobalPos pos) {
        return server.getLevel(pos.dimension());
    }

    public static GlobalPos makeGlobalPos(Level w, BlockPos pos) {
        return GlobalPos.of((ResourceKey)w.dimension(), (BlockPos)pos);
    }

    public static boolean isSameWorld(GlobalPos pos, Level world) {
        return pos.dimension().compareTo(world.dimension()) == 0;
    }

    public static String prettyPrint(GlobalPos pos) {
        BlockPos p = pos.pos();
        String dim = pos.dimension().location().toString();
        return String.format("%s [%d,%d,%d]", dim, p.getX(), p.getY(), p.getZ());
    }

    public static BlockEntity getTileEntity(GlobalPos globalPos) {
        ServerLevel world = GlobalPosHelper.getWorldForGlobalPos(globalPos);
        if (world != null && world.isLoaded(globalPos.pos())) {
            return world.getBlockEntity(globalPos.pos());
        }
        return null;
    }
}

