/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.datagen;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.advancements.CustomTrigger;
import me.desht.pneumaticcraft.common.registry.ModBlocks;
import me.desht.pneumaticcraft.common.registry.ModCriterionTriggers;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemDamagePredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicates;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.data.AdvancementProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.apache.commons.lang3.Validate;

public class ModAdvancementProvider
extends AdvancementProvider {
    private static final ResourceLocation BACKGROUND_TEXTURE = PneumaticRegistry.RL("textures/gui/advancement_bg.png");

    public ModAdvancementProvider(DataGenerator generatorIn, CompletableFuture<HolderLookup.Provider> lookupProvider, ExistingFileHelper existingFileHelper) {
        super(generatorIn.getPackOutput(), lookupProvider, existingFileHelper, List.of(new PNCAdvancements()));
    }

    private static class PNCAdvancements
    implements AdvancementProvider.AdvancementGenerator {
        private PNCAdvancements() {
        }

        public void generate(HolderLookup.Provider registries, Consumer<AdvancementHolder> saver, ExistingFileHelper existingFileHelper) {
            AdvancementHolder root = this.itemAdvancement("root", AdvancementType.TASK, (ItemLike)ModItems.COMPRESSED_IRON_INGOT.get()).rewards(AdvancementRewards.Builder.experience((int)10)).save(saver, PNCAdvancements.id("root"));
            AdvancementHolder oilBucket = this.itemAdvancement("oil_bucket", AdvancementType.TASK, (ItemLike)ModItems.OIL_BUCKET.get()).parent(root).save(saver, PNCAdvancements.id("oil_bucket"));
            AdvancementHolder refinery = this.itemAdvancement("refinery", AdvancementType.GOAL, (ItemLike)ModBlocks.REFINERY.get(), new ItemPredicate[]{this.itemPredicateNoDurability((ItemLike)ModBlocks.REFINERY.get(), 1), this.itemPredicateNoDurability((ItemLike)ModBlocks.REFINERY_OUTPUT.get(), 2)}).parent(oilBucket).rewards(AdvancementRewards.Builder.experience((int)20)).save(saver, PNCAdvancements.id("refinery"));
            this.itemAdvancement("liquid_compressor", AdvancementType.TASK, (ItemLike)ModBlocks.LIQUID_COMPRESSOR.get()).parent(refinery).rewards(AdvancementRewards.Builder.experience((int)10)).save(saver, PNCAdvancements.id("liquid_compressor"));
            AdvancementHolder vortexTube = this.itemAdvancement("vortex_tube", AdvancementType.TASK, (ItemLike)ModBlocks.VORTEX_TUBE.get()).parent(refinery).save(saver, PNCAdvancements.id("vortex_tube"));
            AdvancementHolder lpgBucket = this.itemAdvancement("lpg_bucket", AdvancementType.TASK, (ItemLike)ModItems.LPG_BUCKET.get()).parent(vortexTube).rewards(AdvancementRewards.Builder.experience((int)20)).save(saver, PNCAdvancements.id("lpg_bucket"));
            AdvancementHolder tpp = this.itemAdvancement("tp_plant", AdvancementType.TASK, (ItemLike)ModBlocks.THERMOPNEUMATIC_PROCESSING_PLANT.get()).parent(lpgBucket).rewards(AdvancementRewards.Builder.experience((int)10)).save(saver, PNCAdvancements.id("tp_plant"));
            AdvancementHolder plastic = this.itemAdvancement("plastic", AdvancementType.GOAL, (ItemLike)ModItems.PLASTIC.get()).parent(tpp).rewards(AdvancementRewards.Builder.experience((int)10)).save(saver, PNCAdvancements.id("plastic"));
            AdvancementHolder jackhammer = this.itemAdvancement("jackhammer", AdvancementType.GOAL, (ItemLike)ModItems.JACKHAMMER.get()).parent(plastic).rewards(AdvancementRewards.Builder.experience((int)20)).save(saver, PNCAdvancements.id("jackhammer"));
            this.itemAdvancement("drill_bit_netherite", AdvancementType.CHALLENGE, (ItemLike)ModItems.NETHERITE_DRILL_BIT.get()).parent(jackhammer).rewards(AdvancementRewards.Builder.experience((int)50)).save(saver, PNCAdvancements.id("drill_bit_netherite"));
            AdvancementHolder amadronTablet = this.itemAdvancement("amadron_tablet", AdvancementType.TASK, (ItemLike)ModItems.AMADRON_TABLET.get()).parent(plastic).save(saver, PNCAdvancements.id("amadron_tablet"));
            AdvancementHolder pcbBlueprint = this.itemAdvancement("pcb_blueprint", AdvancementType.TASK, (ItemLike)ModItems.PCB_BLUEPRINT.get()).parent(amadronTablet).rewards(AdvancementRewards.Builder.experience((int)20)).save(saver, PNCAdvancements.id("pcb_blueprint"));
            this.itemAdvancement("uv_light_box", AdvancementType.TASK, (ItemLike)ModBlocks.UV_LIGHT_BOX.get()).parent(pcbBlueprint).save(saver, PNCAdvancements.id("uv_light_box"));
            AdvancementHolder lubricant = this.itemAdvancement("lubricant_bucket", AdvancementType.TASK, (ItemLike)ModItems.LUBRICANT_BUCKET.get()).parent(tpp).save(saver, PNCAdvancements.id("lubricant_bucket"));
            this.itemAdvancement("speed_upgrade", AdvancementType.TASK, new ItemLike[]{ModUpgrades.SPEED.get().getItem()}).parent(lubricant).rewards(AdvancementRewards.Builder.experience((int)15)).save(saver, PNCAdvancements.id("speed_upgrade"));
            AdvancementHolder yeast = this.itemAdvancement("yeast_culture", AdvancementType.TASK, (ItemLike)ModItems.YEAST_CULTURE_BUCKET.get()).parent(tpp).rewards(AdvancementRewards.Builder.experience((int)10)).save(saver, PNCAdvancements.id("yeast_culture"));
            AdvancementHolder ethanol = this.itemAdvancement("ethanol", AdvancementType.TASK, (ItemLike)ModItems.ETHANOL_BUCKET.get()).parent(yeast).rewards(AdvancementRewards.Builder.experience((int)10)).save(saver, PNCAdvancements.id("ethanol"));
            this.itemAdvancement("biodiesel", AdvancementType.GOAL, (ItemLike)ModItems.BIODIESEL_BUCKET.get()).parent(ethanol).rewards(AdvancementRewards.Builder.experience((int)25)).save(saver, PNCAdvancements.id("biodiesel"));
            AdvancementHolder pressureTube = this.itemAdvancement("pressure_tube", AdvancementType.TASK, (ItemLike)ModBlocks.PRESSURE_TUBE.get()).parent(root).save(saver, PNCAdvancements.id("pressure_tube"));
            this.itemAdvancement("air_compressor", AdvancementType.TASK, (ItemLike)ModBlocks.AIR_COMPRESSOR.get()).parent(pressureTube).rewards(AdvancementRewards.Builder.experience((int)10)).save(saver, PNCAdvancements.id("air_compressor"));
            this.itemAdvancement("minigun", AdvancementType.TASK, (ItemLike)ModItems.MINIGUN.get()).parent(pressureTube).rewards(AdvancementRewards.Builder.experience((int)10)).save(saver, PNCAdvancements.id("minigun"));
            AdvancementHolder wrench = this.itemAdvancement("pneumatic_wrench", AdvancementType.TASK, (ItemLike)ModItems.PNEUMATIC_WRENCH.get(), new ItemPredicate[]{this.itemPredicateNoNBT((ItemLike)ModItems.PNEUMATIC_WRENCH.get(), 1)}).parent(pressureTube).rewards(AdvancementRewards.Builder.experience((int)10)).save(saver, PNCAdvancements.id("pneumatic_wrench"));
            this.customAdvancement(ModCriterionTriggers.CHARGED_WRENCH, AdvancementType.TASK, (ItemLike)ModItems.PNEUMATIC_WRENCH.get()).parent(wrench).rewards(AdvancementRewards.Builder.experience((int)10)).save(saver, PNCAdvancements.id("pneumatic_wrench_charged"));
            this.customAdvancement(ModCriterionTriggers.MACHINE_VANDAL, AdvancementType.TASK, (ItemLike)Items.IRON_PICKAXE).parent(wrench).save(saver, PNCAdvancements.id("machine_vandal"));
            AdvancementHolder frames = this.itemAdvancement("logistics_frame", AdvancementType.TASK, (ItemLike)ModItems.LOGISTICS_FRAME_PASSIVE_PROVIDER.get(), new ItemPredicate[]{this.itemPredicate((ItemLike)ModItems.LOGISTICS_FRAME_PASSIVE_PROVIDER.get(), 1), this.itemPredicate((ItemLike)ModItems.LOGISTICS_FRAME_REQUESTER.get(), 1)}).parent(root).rewards(AdvancementRewards.Builder.experience((int)20)).save(saver, PNCAdvancements.id("logistics_frame"));
            AdvancementHolder configurator = this.itemAdvancement("logistics_configurator", AdvancementType.TASK, (ItemLike)ModItems.LOGISTICS_CONFIGURATOR.get()).parent(frames).rewards(AdvancementRewards.Builder.experience((int)10)).save(saver, PNCAdvancements.id("logistics_configurator"));
            this.customAdvancement(ModCriterionTriggers.LOGISTICS_DRONE_DEPLOYED, AdvancementType.GOAL, (ItemLike)ModItems.LOGISTICS_DRONE.get()).parent(configurator).rewards(AdvancementRewards.Builder.experience((int)10)).save(saver, PNCAdvancements.id("logistics_drone"));
            AdvancementHolder pressureChamber = this.customAdvancement(ModCriterionTriggers.PRESSURE_CHAMBER, AdvancementType.GOAL, (ItemLike)ModBlocks.PRESSURE_CHAMBER_WALL.get()).parent(root).rewards(AdvancementRewards.Builder.experience((int)20)).save(saver, PNCAdvancements.id("pressure_chamber"));
            AdvancementHolder etchingAcid = this.itemAdvancement("etchacid_bucket", AdvancementType.TASK, (ItemLike)ModItems.ETCHING_ACID_BUCKET.get()).parent(pressureChamber).save(saver, PNCAdvancements.id("etchacid_bucket"));
            AdvancementHolder emptyPCB = this.itemAdvancement("empty_pcb", AdvancementType.TASK, (ItemLike)ModItems.EMPTY_PCB.get()).parent(etchingAcid).save(saver, PNCAdvancements.id("empty_pcb"));
            AdvancementHolder unassembledPCB = this.itemAdvancement("unassembled_pcb", AdvancementType.TASK, (ItemLike)ModItems.UNASSEMBLED_PCB.get()).parent(emptyPCB).save(saver, PNCAdvancements.id("unassembled_pcb"));
            AdvancementHolder pcb = this.itemAdvancement("printed_circuit_board", AdvancementType.GOAL, (ItemLike)ModItems.PRINTED_CIRCUIT_BOARD.get()).parent(unassembledPCB).rewards(AdvancementRewards.Builder.experience((int)20)).save(saver, PNCAdvancements.id("printed_circuit_board"));
            AdvancementHolder armor = this.customAdvancement(ModCriterionTriggers.PNEUMATIC_ARMOR, AdvancementType.TASK, (ItemLike)ModItems.PNEUMATIC_HELMET.get()).parent(pcb).rewards(AdvancementRewards.Builder.experience((int)20)).save(saver, PNCAdvancements.id("pneumatic_armor"));
            AdvancementHolder jetBoots = this.customAdvancement(ModCriterionTriggers.FLIGHT, AdvancementType.CHALLENGE, (ItemLike)ModUpgrades.JET_BOOTS.get().getItem()).parent(armor).rewards(AdvancementRewards.Builder.experience((int)50)).save(saver, PNCAdvancements.id("flight"));
            this.customAdvancement(ModCriterionTriggers.FLY_INTO_WALL, AdvancementType.TASK, (ItemLike)Blocks.BRICKS).parent(jetBoots).save(saver, PNCAdvancements.id("fly_into_wall"));
            this.customAdvancement(ModCriterionTriggers.BLOCK_HACK, AdvancementType.TASK, (ItemLike)ModUpgrades.BLOCK_TRACKER.get().getItem()).parent(armor).rewards(AdvancementRewards.Builder.experience((int)10)).save(saver, PNCAdvancements.id("block_hack"));
            this.customAdvancement(ModCriterionTriggers.ENTITY_HACK, AdvancementType.TASK, (ItemLike)ModUpgrades.ENTITY_TRACKER.get().getItem()).parent(armor).rewards(AdvancementRewards.Builder.experience((int)10)).save(saver, PNCAdvancements.id("entity_hack"));
            AdvancementHolder assembly = this.itemAdvancement("assembly_controller", AdvancementType.GOAL, (ItemLike)ModBlocks.ASSEMBLY_CONTROLLER.get()).parent(pcb).rewards(AdvancementRewards.Builder.experience((int)30)).save(saver, PNCAdvancements.id("assembly_controller"));
            AdvancementHolder advancedTube = this.itemAdvancement("advanced_pressure_tube", AdvancementType.TASK, (ItemLike)ModBlocks.ADVANCED_PRESSURE_TUBE.get()).parent(assembly).rewards(AdvancementRewards.Builder.experience((int)10)).save(saver, PNCAdvancements.id("advanced_pressure_tube"));
            this.itemAdvancement("aerial_interface", AdvancementType.TASK, (ItemLike)ModBlocks.AERIAL_INTERFACE.get()).parent(advancedTube).rewards(AdvancementRewards.Builder.experience((int)10)).save(saver, PNCAdvancements.id("aerial_interface"));
            this.itemAdvancement("programmable_controller", AdvancementType.TASK, (ItemLike)ModBlocks.PROGRAMMABLE_CONTROLLER.get()).parent(advancedTube).rewards(AdvancementRewards.Builder.experience((int)10)).save(saver, PNCAdvancements.id("programmable_controller"));
            this.itemAdvancement("flux_compressor", AdvancementType.TASK, (ItemLike)ModBlocks.FLUX_COMPRESSOR.get()).parent(advancedTube).rewards(AdvancementRewards.Builder.experience((int)10)).save(saver, PNCAdvancements.id("flux_compressor"));
            this.itemAdvancement("aphorism_tile", AdvancementType.TASK, (ItemLike)ModBlocks.APHORISM_TILE.get()).parent(assembly).save(saver, PNCAdvancements.id("aphorism_tile"));
            AdvancementHolder programmer = this.itemAdvancement("programmer", AdvancementType.TASK, (ItemLike)ModBlocks.PROGRAMMER.get()).parent(pcb).save(saver, PNCAdvancements.id("programmer"));
            AdvancementHolder puzzle = this.itemAdvancement("programming_puzzle", AdvancementType.TASK, (ItemLike)ModItems.PROGRAMMING_PUZZLE.get()).parent(programmer).save(saver, PNCAdvancements.id("programming_puzzle"));
            this.customAdvancement(ModCriterionTriggers.PROGRAM_DRONE, AdvancementType.CHALLENGE, (ItemLike)ModItems.DRONE.get()).parent(puzzle).rewards(AdvancementRewards.Builder.experience((int)50)).save(saver, PNCAdvancements.id("program_drone"));
        }

        private static String id(String s) {
            return "pneumaticcraft:" + s;
        }

        private Advancement.Builder customAdvancement(Supplier<CustomTrigger> triggerSupplier, AdvancementType type, ItemLike itemDisp) {
            CustomTrigger trigger = triggerSupplier.get();
            String namespace = trigger.getInstance().id().getNamespace();
            String path = trigger.getInstance().id().getPath();
            return Advancement.Builder.advancement().display(itemDisp, (Component)PneumaticCraftUtils.xlate(namespace + ".advancement." + path, new Object[0]), (Component)PneumaticCraftUtils.xlate(namespace + ".advancement." + path + ".desc", new Object[0]), BACKGROUND_TEXTURE, type, true, true, false).addCriterion("0", new Criterion((CriterionTrigger)trigger, (CriterionTriggerInstance)trigger.getInstance()));
        }

        private Advancement.Builder itemAdvancement(String name, AdvancementType type, ItemLike ... items) {
            Validate.isTrue((items.length > 0 ? 1 : 0) != 0);
            return Advancement.Builder.advancement().display(items[0], (Component)PneumaticCraftUtils.xlate("pneumaticcraft.advancement." + name, new Object[0]), (Component)PneumaticCraftUtils.xlate("pneumaticcraft.advancement." + name + ".desc", new Object[0]), BACKGROUND_TEXTURE, type, true, true, false).addCriterion("0", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])items));
        }

        private Advancement.Builder itemAdvancement(String name, AdvancementType type, ItemLike item, ItemPredicate[] predicates) {
            return Advancement.Builder.advancement().display(item, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.advancement." + name, new Object[0]), (Component)PneumaticCraftUtils.xlate("pneumaticcraft.advancement." + name + ".desc", new Object[0]), BACKGROUND_TEXTURE, type, true, true, false).addCriterion("0", InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])predicates));
        }

        private ItemPredicate itemPredicateNoDurability(ItemLike item, int minCount) {
            return ItemPredicate.Builder.item().of(new ItemLike[]{item.asItem()}).withCount(MinMaxBounds.Ints.atLeast((int)minCount)).build();
        }

        private ItemPredicate itemPredicate(ItemLike item, int minCount) {
            return ItemPredicate.Builder.item().of(new ItemLike[]{item.asItem()}).withCount(MinMaxBounds.Ints.atLeast((int)minCount)).withSubPredicate(ItemSubPredicates.DAMAGE, (ItemSubPredicate)ItemDamagePredicate.durability((MinMaxBounds.Ints)MinMaxBounds.Ints.ANY)).build();
        }

        private ItemPredicate itemPredicateNoNBT(ItemLike item, int minCount) {
            return ItemPredicate.Builder.item().of(new ItemLike[]{item.asItem()}).withCount(MinMaxBounds.Ints.atLeast((int)minCount)).withSubPredicate(ItemSubPredicates.DAMAGE, (ItemSubPredicate)ItemDamagePredicate.durability((MinMaxBounds.Ints)MinMaxBounds.Ints.ANY)).build();
        }
    }
}

