/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftContainerScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextField;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.block.entity.SentryTurretBlockEntity;
import me.desht.pneumaticcraft.common.inventory.SentryTurretMenu;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketUpdateTextfield;
import me.desht.pneumaticcraft.common.util.EntityFilter;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class SentryTurretScreen
extends AbstractPneumaticCraftContainerScreen<SentryTurretMenu, SentryTurretBlockEntity> {
    private WidgetTextField entityFilter;
    private WidgetButtonExtended errorButton;

    public SentryTurretScreen(SentryTurretMenu container, Inventory inv, Component displayString) {
        super(container, inv, displayString);
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_SENTRY_TURRET;
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        Objects.requireNonNull(this.f_96547_);
        this.entityFilter = new WidgetTextField(this.f_96547_, this.f_97735_ + 80, this.f_97736_ + 63, 70, 9);
        this.m_142416_((GuiEventListener)this.entityFilter);
        this.entityFilter.m_94199_(256);
        this.m_7522_((GuiEventListener)this.entityFilter);
        this.errorButton = new WidgetButtonExtended(this.f_97735_ + 155, this.f_97736_ + 52, 16, 16, (Component)Component.m_237119_());
        this.m_142416_((GuiEventListener)this.errorButton);
        this.errorButton.setRenderedIcon(Textures.GUI_PROBLEMS_TEXTURE).setVisible(false);
        this.errorButton.f_93624_ = false;
    }

    @Override
    public void m_181908_() {
        if (this.firstUpdate) {
            this.entityFilter.m_94144_(((SentryTurretBlockEntity)this.te).getText(0));
            this.entityFilter.m_94151_(this::onEntityFilterChanged);
        }
        super.m_181908_();
    }

    private void onEntityFilterChanged(String newText) {
        try {
            new EntityFilter(newText);
            this.errorButton.f_93624_ = false;
            this.errorButton.setTooltipText(Collections.emptyList());
            this.sendDelayed(5);
        }
        catch (IllegalArgumentException e) {
            this.errorButton.f_93624_ = true;
            this.errorButton.setTooltipText((Component)Component.m_237113_((String)e.getMessage()));
        }
    }

    @Override
    protected void doDelayedAction() {
        ((SentryTurretBlockEntity)this.te).setText(0, this.entityFilter.m_94155_());
        NetworkHandler.sendToServer(new PacketUpdateTextfield(this.te, 0));
    }

    @Override
    protected void m_280003_(GuiGraphics graphics, int x, int y) {
        super.m_280003_(graphics, x, y);
        graphics.m_280614_(this.f_96547_, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.sentryTurret.ammo", new Object[0]), 80, 19, 0x404040, false);
        graphics.m_280614_(this.f_96547_, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.sentryTurret.targetFilter", new Object[0]), 80, 53, 0x404040, false);
        if (ClientUtils.isKeyDown(290)) {
            GuiUtils.showPopupHelpScreen(graphics, (Screen)this, this.f_96547_, GuiUtils.xlateAndSplit("pneumaticcraft.gui.entityFilter.helpText", new Object[0]));
        } else if (x >= this.f_97735_ + 76 && y >= this.f_97736_ + 51 && x <= this.f_97735_ + 153 && y <= this.f_97736_ + 74) {
            MutableComponent str = PneumaticCraftUtils.xlate("pneumaticcraft.gui.entityFilter.holdF1", new Object[0]);
            graphics.m_280614_(this.f_96547_, (Component)str, (this.f_97726_ - this.f_96547_.m_92852_((FormattedText)str)) / 2, this.f_97727_ + 5, 0x808080, false);
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.f_96541_.f_91074_.m_6915_();
        }
        return this.entityFilter.m_7933_(keyCode, scanCode, modifiers) || this.entityFilter.m_94204_() || super.m_7933_(keyCode, scanCode, modifiers);
    }

    @Override
    protected void addProblems(List<Component> curInfo) {
        super.addProblems(curInfo);
        boolean hasAmmo = false;
        for (int i = 0; i < ((SentryTurretBlockEntity)this.te).getPrimaryInventory().getSlots(); ++i) {
            if (((SentryTurretBlockEntity)this.te).getPrimaryInventory().getStackInSlot(i).m_41619_()) continue;
            hasAmmo = true;
            break;
        }
        if (!hasAmmo) {
            curInfo.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.sentryTurret.noAmmo", new Object[0]));
        }
    }
}

