/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.programmer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import me.desht.pneumaticcraft.api.item.IPositionProvider;
import me.desht.pneumaticcraft.client.gui.InventorySearcherScreen;
import me.desht.pneumaticcraft.client.gui.ProgrammerScreen;
import me.desht.pneumaticcraft.client.gui.programmer.ProgWidgetAreaShowScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetCheckBox;
import me.desht.pneumaticcraft.client.gui.widget.WidgetComboBox;
import me.desht.pneumaticcraft.client.gui.widget.WidgetLabel;
import me.desht.pneumaticcraft.client.gui.widget.WidgetRadioButton;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextFieldNumber;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.block.entity.ProgrammerBlockEntity;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.core.ModMenuTypes;
import me.desht.pneumaticcraft.common.drone.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetArea;
import me.desht.pneumaticcraft.common.drone.progwidgets.area.AreaType;
import me.desht.pneumaticcraft.common.item.GPSToolItem;
import me.desht.pneumaticcraft.common.util.ITranslatableEnum;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class ProgWidgetAreaScreen
extends ProgWidgetAreaShowScreen<ProgWidgetArea> {
    private InventorySearcherScreen invSearchGui;
    private int pointSearched;
    private WidgetComboBox variableField1;
    private WidgetComboBox variableField2;
    private final List<AreaType> allAreaTypes = ProgWidgetArea.getAllAreaTypes();
    private final List<Pair<AreaType.AreaTypeWidget, AbstractWidget>> areaTypeValueWidgets = new ArrayList<Pair<AreaType.AreaTypeWidget, AbstractWidget>>();
    private final List<AbstractWidget> areaTypeStaticWidgets = new ArrayList<AbstractWidget>();

    public ProgWidgetAreaScreen(ProgWidgetArea widget, ProgrammerScreen guiProgrammer) {
        super(widget, guiProgrammer);
        this.xSize = 256;
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        boolean advancedMode = ConfigHelper.client().general.programmerDifficulty.get() == IProgWidget.WidgetDifficulty.ADVANCED;
        WidgetButtonExtended gpsButton1 = new WidgetButtonExtended(this.guiLeft + (advancedMode ? 6 : 55), this.guiTop + 30, 20, 20, (Component)Component.m_237119_(), b -> this.openInvSearchGUI(0)).setRenderStacks(new ItemStack((ItemLike)ModItems.GPS_TOOL.get())).setTooltipText((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.area.selectGPS1", new Object[0]));
        this.m_142416_((GuiEventListener)gpsButton1);
        WidgetButtonExtended gpsButton2 = new WidgetButtonExtended(this.guiLeft + (advancedMode ? 133 : 182), this.guiTop + 30, 20, 20, (Component)Component.m_237119_(), b -> this.openInvSearchGUI(1)).setRenderStacks(new ItemStack((ItemLike)ModItems.GPS_TOOL.get())).setTooltipText((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.area.selectGPS2", new Object[0]));
        this.m_142416_((GuiEventListener)gpsButton2);
        Objects.requireNonNull(this.f_96547_);
        this.variableField1 = new WidgetComboBox(this.f_96547_, this.guiLeft + 28, this.guiTop + 35, 88, 9 + 1);
        Objects.requireNonNull(this.f_96547_);
        this.variableField2 = new WidgetComboBox(this.f_96547_, this.guiLeft + 155, this.guiTop + 35, 88, 9 + 1);
        Set<String> variables = this.guiProgrammer == null ? Collections.emptySet() : ((ProgrammerBlockEntity)this.guiProgrammer.te).getAllVariables();
        this.variableField1.setElements(variables);
        this.variableField2.setElements(variables);
        this.variableField1.m_94144_(((ProgWidgetArea)this.progWidget).getVarName(0));
        this.variableField2.m_94144_(((ProgWidgetArea)this.progWidget).getVarName(1));
        if (advancedMode) {
            this.m_142416_((GuiEventListener)this.variableField1);
            this.m_142416_((GuiEventListener)this.variableField2);
        }
        this.addLabel((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.area.type", new Object[0]), this.guiLeft + 8, this.guiTop + 88);
        int widgetsPerColumn = 5;
        WidgetRadioButton.Builder<WidgetRadioButton> builder = WidgetRadioButton.Builder.create();
        for (int i = 0; i < this.allAreaTypes.size(); ++i) {
            AreaType areaType = this.allAreaTypes.get(i);
            WidgetRadioButton radioButton = new WidgetRadioButton(this.guiLeft + 5 + i / 5 * 80, this.guiTop + 100 + i % 5 * 12, -12566464, (Component)PneumaticCraftUtils.xlate(areaType.getTranslationKey(), new Object[0]), b -> {
                ((ProgWidgetArea)this.progWidget).type = areaType;
                this.switchToWidgets(areaType);
            });
            if (((ProgWidgetArea)this.progWidget).type.getClass() == areaType.getClass()) {
                this.allAreaTypes.set(i, ((ProgWidgetArea)this.progWidget).type);
            }
            builder.addRadioButton(radioButton, ((ProgWidgetArea)this.progWidget).type.getClass() == areaType.getClass());
        }
        builder.build(x$0 -> {
            WidgetRadioButton cfr_ignored_0 = (WidgetRadioButton)this.m_142416_((GuiEventListener)x$0);
        });
        this.switchToWidgets(((ProgWidgetArea)this.progWidget).type);
        if (this.invSearchGui != null) {
            ((ProgWidgetArea)this.progWidget).setPos(this.pointSearched, this.invSearchGui.getBlockPos());
            this.invSearchGui = null;
        }
        String l1 = "P1: " + ChatFormatting.DARK_BLUE + this.formatPos(((ProgWidgetArea)this.progWidget).getPos(0).orElse(PneumaticCraftUtils.invalidPos()));
        this.addLabel((Component)Component.m_237113_((String)l1), this.guiLeft + 8, this.guiTop + 20);
        String l2 = "P2: " + ChatFormatting.DARK_BLUE + this.formatPos(((ProgWidgetArea)this.progWidget).getPos(1).orElse(PneumaticCraftUtils.invalidPos()));
        this.addLabel((Component)Component.m_237113_((String)l2), this.guiLeft + 133, this.guiTop + 20);
    }

    private String formatPos(BlockPos pos) {
        return PneumaticCraftUtils.isValidPos(pos) ? String.format("[ %d, %d, %d ]", pos.m_123341_(), pos.m_123342_(), pos.m_123343_()) : "-";
    }

    private void openInvSearchGUI(int which) {
        ItemStack gpsStack = new ItemStack((ItemLike)ModItems.GPS_TOOL.get());
        GPSToolItem.setGPSLocation(ClientUtils.getClientPlayer().m_20148_(), gpsStack, ((ProgWidgetArea)this.progWidget).getPos(which).orElse(BlockPos.f_121853_));
        ClientUtils.openContainerGui((MenuType<? extends AbstractContainerMenu>)((MenuType)ModMenuTypes.INVENTORY_SEARCHER.get()), (Component)Component.m_237113_((String)"Inventory Searcher (GPS)"));
        if (this.f_96541_.f_91080_ instanceof InventorySearcherScreen) {
            this.invSearchGui = (InventorySearcherScreen)this.f_96541_.f_91080_;
            this.invSearchGui.setStackPredicate(itemStack -> itemStack.m_41720_() instanceof IPositionProvider);
            this.invSearchGui.setSearchStack(GPSToolItem.getGPSLocation(gpsStack).isPresent() ? gpsStack : ItemStack.f_41583_);
        }
        this.pointSearched = which;
    }

    private void switchToWidgets(AreaType type) {
        this.saveWidgets();
        this.areaTypeValueWidgets.forEach(p -> this.m_169411_((GuiEventListener)p.getRight()));
        this.areaTypeStaticWidgets.forEach(x$0 -> this.m_169411_((GuiEventListener)x$0));
        this.areaTypeValueWidgets.clear();
        this.areaTypeStaticWidgets.clear();
        int curY = this.guiTop + 100;
        int x = this.guiLeft + 150;
        ArrayList<AreaType.AreaTypeWidget> atWidgets = new ArrayList<AreaType.AreaTypeWidget>();
        type.addUIWidgets(atWidgets);
        for (AreaType.AreaTypeWidget areaTypeWidget : atWidgets) {
            WidgetLabel titleWidget = new WidgetLabel(x, curY, (Component)PneumaticCraftUtils.xlate(areaTypeWidget.title, new Object[0]));
            this.m_142416_((GuiEventListener)titleWidget);
            this.areaTypeStaticWidgets.add(titleWidget);
            Objects.requireNonNull(this.f_96547_);
            curY += 9 + 1;
            if (areaTypeWidget instanceof AreaType.AreaTypeWidgetInteger) {
                AreaType.AreaTypeWidgetInteger intWidget = (AreaType.AreaTypeWidgetInteger)areaTypeWidget;
                Objects.requireNonNull(this.f_96547_);
                WidgetTextFieldNumber intField = new WidgetTextFieldNumber(this.f_96547_, x, curY, 40, 9 + 1).setRange(0, Integer.MAX_VALUE);
                intField.setValue(intWidget.readAction.getAsInt());
                this.m_142416_((GuiEventListener)intField);
                this.areaTypeValueWidgets.add((Pair<AreaType.AreaTypeWidget, AbstractWidget>)new ImmutablePair((Object)areaTypeWidget, (Object)intField));
                Objects.requireNonNull(this.f_96547_);
                curY += 9 + 20;
                continue;
            }
            if (areaTypeWidget instanceof AreaType.AreaTypeWidgetEnum) {
                AreaType.AreaTypeWidgetEnum enumWidget = (AreaType.AreaTypeWidgetEnum)areaTypeWidget;
                Objects.requireNonNull(this.f_96547_);
                WidgetComboBox enumCbb = new WidgetComboBox(this.f_96547_, x, curY, 80, 9 + 1).setFixedOptions(true);
                enumCbb.setElements(this.getEnumNames(enumWidget.enumClass));
                String txt = PneumaticCraftUtils.xlate(((ITranslatableEnum)enumWidget.readAction.get()).getTranslationKey(), new Object[0]).getString();
                enumCbb.m_94144_(txt);
                this.m_142416_((GuiEventListener)enumCbb);
                this.areaTypeValueWidgets.add((Pair<AreaType.AreaTypeWidget, AbstractWidget>)new ImmutablePair((Object)areaTypeWidget, (Object)enumCbb));
                Objects.requireNonNull(this.f_96547_);
                curY += 9 + 20;
                continue;
            }
            throw new IllegalStateException("Invalid widget type: " + areaTypeWidget.getClass());
        }
    }

    private void saveWidgets() {
        for (Pair<AreaType.AreaTypeWidget, AbstractWidget> entry : this.areaTypeValueWidgets) {
            AreaType.AreaTypeWidget widget = (AreaType.AreaTypeWidget)entry.getLeft();
            AbstractWidget guiWidget = (AbstractWidget)entry.getRight();
            if (widget instanceof AreaType.AreaTypeWidgetInteger) {
                AreaType.AreaTypeWidgetInteger intWidget = (AreaType.AreaTypeWidgetInteger)widget;
                intWidget.writeAction.accept(((WidgetTextFieldNumber)guiWidget).getIntValue());
                continue;
            }
            if (!(widget instanceof AreaType.AreaTypeWidgetEnum)) continue;
            AreaType.AreaTypeWidgetEnum enumWidget = (AreaType.AreaTypeWidgetEnum)widget;
            WidgetComboBox cbb = (WidgetComboBox)guiWidget;
            List<String> enumNames = this.getEnumNames(enumWidget.enumClass);
            E[] enumValues = enumWidget.enumClass.getEnumConstants();
            Object e = enumValues[enumNames.indexOf(cbb.m_94155_())];
            if (!(e instanceof ITranslatableEnum)) continue;
            ITranslatableEnum tr = (ITranslatableEnum)e;
            enumWidget.writeAction.accept(tr);
        }
    }

    private List<String> getEnumNames(Class<?> enumClass) {
        ?[] enumValues = enumClass.getEnumConstants();
        ArrayList<String> enumNames = new ArrayList<String>();
        for (Object enumValue : enumValues) {
            if (enumValue instanceof ITranslatableEnum) {
                ITranslatableEnum t = (ITranslatableEnum)enumValue;
                enumNames.add(PneumaticCraftUtils.xlate(t.getTranslationKey(), new Object[0]).getString());
                continue;
            }
            enumNames.add(enumValue.toString());
        }
        return enumNames;
    }

    @Override
    protected void previewArea(WidgetCheckBox button) {
        super.previewArea(button);
        this.saveWidgets();
    }

    @Override
    protected ResourceLocation getTexture() {
        return Textures.GUI_WIDGET_AREA;
    }

    @Override
    public void m_7861_() {
        ((ProgWidgetArea)this.progWidget).setVarName(0, this.variableField1.m_94155_());
        ((ProgWidgetArea)this.progWidget).setVarName(1, this.variableField2.m_94155_());
        this.saveWidgets();
        super.m_7861_();
    }
}

