/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import java.util.Objects;
import java.util.function.Consumer;
import me.desht.pneumaticcraft.client.gui.widget.WidgetFluidFilter;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.thirdparty.ModNameCache;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.fluids.FluidStack;

public class WidgetFluidStack
extends WidgetFluidFilter {
    private static final float TEXT_SCALE = 0.5f;
    private boolean adjustable = false;

    public WidgetFluidStack(int x, int y, FluidStack stack, Consumer<WidgetFluidFilter> pressable) {
        super(x, y, stack, pressable);
    }

    public WidgetFluidStack setAdjustable() {
        this.adjustable = true;
        return this;
    }

    public FluidStack getFluidStack() {
        return this.fluidStack;
    }

    public WidgetFluidStack setFluidStack(FluidStack fluidStack) {
        this.fluidStack = fluidStack;
        return this;
    }

    @Override
    public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.m_87963_(graphics, mouseX, mouseY, partialTick);
        if (!this.fluidStack.isEmpty()) {
            int fluidAmount = this.fluidStack.getAmount() / 1000;
            if (fluidAmount > 1 || this.adjustable) {
                Font font = Minecraft.m_91087_().f_91062_;
                MutableComponent str = Component.m_237113_((String)(fluidAmount + "B"));
                int n = (int)((float)this.m_252754_() - (float)font.m_92852_((FormattedText)str) * 0.5f + 16.0f);
                float f = this.m_252907_() + 16;
                Objects.requireNonNull(font);
                GuiUtils.drawScaledText(graphics, font, (Component)str, n, (int)(f - 9.0f * 0.5f), 0xFFFFFF, 0.5f, true);
            }
            MutableComponent c = new FluidStack(this.fluidStack, 1).getDisplayName().m_6881_();
            if (this.adjustable) {
                c.m_130946_("\n").m_7220_((Component)PneumaticCraftUtils.xlate("pneumaticcraft.message.misc.fluidmB", this.fluidStack.getAmount()).m_130940_(ChatFormatting.GRAY));
            }
            c.m_130946_("\n").m_7220_((Component)Component.m_237113_((String)ModNameCache.getModName(this.fluidStack.getFluid())).m_130944_(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC}));
            this.m_257544_(Tooltip.m_257550_((Component)c));
        } else {
            this.m_257544_(null);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.m_93680_(mouseX, mouseY)) {
            if (!this.fluidStack.isEmpty() && this.adjustable) {
                boolean shift = Screen.m_96638_();
                switch (button) {
                    case 0: {
                        this.fluidStack.setAmount(shift ? this.fluidStack.getAmount() / 2 : Math.max(0, this.fluidStack.getAmount() - 1000));
                        if (this.fluidStack.getAmount() >= 1000) break;
                        this.fluidStack.setAmount(0);
                        break;
                    }
                    case 1: {
                        this.fluidStack.setAmount(shift ? this.fluidStack.getAmount() * 2 : this.fluidStack.getAmount() + 1000);
                        break;
                    }
                    case 2: {
                        this.fluidStack.setAmount(0);
                    }
                }
            }
            if (this.pressable != null) {
                this.pressable.accept(this);
            }
            return true;
        }
        return false;
    }
}

