/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity;

import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.pressure.PressureTier;
import me.desht.pneumaticcraft.common.block.entity.AbstractAirHandlingBlockEntity;
import me.desht.pneumaticcraft.common.core.ModBlockEntities;
import me.desht.pneumaticcraft.common.inventory.CreativeCompressorMenu;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;

public class CreativeCompressorBlockEntity
extends AbstractAirHandlingBlockEntity
implements MenuProvider {
    @GuiSynced
    private float pressureSetpoint;

    public CreativeCompressorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.CREATIVE_COMPRESSOR.get(), pos, state, PressureTier.TIER_TWO, 50000, 0);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.pressureSetpoint = tag.m_128457_("setpoint");
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128350_("setpoint", this.pressureSetpoint);
    }

    @Override
    public void tickServer() {
        super.tickServer();
        this.airHandler.setPressure(this.pressureSetpoint);
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayer player) {
        try {
            this.pressureSetpoint += Float.parseFloat(tag);
            if (this.pressureSetpoint > 30.0f) {
                this.pressureSetpoint = 30.0f;
            }
            if (this.pressureSetpoint < -1.0f) {
                this.pressureSetpoint = -1.0f;
            }
            this.m_6596_();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return null;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new CreativeCompressorMenu(i, playerInventory, this.m_58899_());
    }
}

