/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.item.IInventoryItem;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.api.item.ILaunchBehaviour;
import me.desht.pneumaticcraft.api.item.IMagnetSuppressor;
import me.desht.pneumaticcraft.api.item.ISpawnerCoreStats;
import me.desht.pneumaticcraft.api.item.ItemVolumeModifier;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerItem;
import me.desht.pneumaticcraft.common.capabilities.AirHandlerItemStack;
import me.desht.pneumaticcraft.common.item.SpawnerCoreItem;
import me.desht.pneumaticcraft.common.util.ItemLaunching;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.Validate;

public enum ItemRegistry implements IItemRegistry
{
    INSTANCE;

    private final List<Item> inventoryItemBlacklist = new ArrayList<Item>();
    public final List<IInventoryItem> inventoryItems = new ArrayList<IInventoryItem>();
    private final List<IMagnetSuppressor> magnetSuppressors = new ArrayList<IMagnetSuppressor>();
    private final List<ItemVolumeModifier> volumeModifiers = new ArrayList<ItemVolumeModifier>();

    public static ItemRegistry getInstance() {
        return INSTANCE;
    }

    @Override
    public void registerInventoryItem(@Nonnull IInventoryItem handler) {
        Validate.notNull((Object)handler);
        this.inventoryItems.add(handler);
    }

    @Override
    public void registerMagnetSuppressor(IMagnetSuppressor suppressor) {
        this.magnetSuppressors.add(suppressor);
    }

    @Override
    public boolean doesItemMatchFilter(@Nonnull ItemStack filterStack, @Nonnull ItemStack stack, boolean checkDurability, boolean checkNBT, boolean checkModSimilarity) {
        return PneumaticCraftUtils.doesItemMatchFilter(filterStack, stack, checkDurability, checkNBT, checkModSimilarity);
    }

    @Override
    public void registerPneumaticVolumeModifier(ItemVolumeModifier modifierFunc) {
        this.volumeModifiers.add(modifierFunc);
    }

    @Override
    public ISpawnerCoreStats getSpawnerCoreStats(ItemStack stack) {
        Validate.isTrue((boolean)(stack.m_41720_() instanceof SpawnerCoreItem), (String)"item is not a Spawner Core!", (Object[])new Object[0]);
        return SpawnerCoreItem.SpawnerCoreStats.forItemStack(stack);
    }

    @Override
    public IAirHandlerItem.Provider makeItemAirHandlerProvider(ItemStack stack) {
        return new AirHandlerItemStack(stack);
    }

    @Override
    public void registerItemLaunchBehaviour(ILaunchBehaviour behaviour) {
        ItemLaunching.registerBehaviour(behaviour);
    }

    public boolean shouldSuppressMagnet(Entity e) {
        return this.magnetSuppressors.stream().anyMatch(s -> s.shouldSuppressMagnet(e));
    }

    @Override
    public int getModifiedVolume(ItemStack stack, int originalVolume) {
        for (ItemVolumeModifier modifier : this.volumeModifiers) {
            originalVolume = modifier.getNewVolume(stack, originalVolume);
        }
        return originalVolume;
    }

    public void addVolumeModifierInfo(ItemStack stack, List<Component> text) {
        this.volumeModifiers.forEach(modifier -> modifier.addInfo(stack, text));
    }

    public List<ItemStack> getStacksInItem(@Nonnull ItemStack item) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (item.m_41720_() instanceof IInventoryItem && !this.inventoryItemBlacklist.contains(item.m_41720_())) {
            try {
                ((IInventoryItem)item.m_41720_()).getStacksInItem(item, items);
            }
            catch (Throwable e) {
                Log.error("An InventoryItem crashed:", new Object[0]);
                e.printStackTrace();
                this.inventoryItemBlacklist.add(item.m_41720_());
            }
        } else {
            Iterator<IInventoryItem> iterator = ItemRegistry.getInstance().inventoryItems.iterator();
            while (iterator.hasNext()) {
                try {
                    iterator.next().getStacksInItem(item, items);
                }
                catch (Throwable e) {
                    Log.error("An InventoryItem crashed:", new Object[0]);
                    e.printStackTrace();
                    iterator.remove();
                }
            }
        }
        return items;
    }
}

