/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tubemodules;

import java.util.Set;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.common.block.entity.PressureTubeBlockEntity;
import me.desht.pneumaticcraft.common.tubemodules.AbstractTubeModule;
import me.desht.pneumaticcraft.common.tubemodules.ModuleNetworkManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;

public abstract class AbstractNetworkedRedstoneModule
extends AbstractTubeModule {
    private int inputLevel = -1;
    private boolean inputChangedThisTick = false;
    private boolean inputUpdateQueued = false;

    AbstractNetworkedRedstoneModule(Direction dir, PressureTubeBlockEntity pressureTube) {
        super(dir, pressureTube);
    }

    @Override
    public void tickServer() {
        super.tickServer();
        if (this.getInputChannel() != -1 && this.inputLevel == -1) {
            this.updateInputLevel();
        }
        this.inputChangedThisTick = false;
        boolean wasInputUpdateQueued = this.inputUpdateQueued;
        this.inputUpdateQueued = false;
        if (wasInputUpdateQueued) {
            this.updateInputLevel();
        }
    }

    protected int getInputChannel() {
        return -1;
    }

    public int getInputLevel() {
        return this.inputLevel;
    }

    public void setInputLevel(int inputLevel) {
        this.inputLevel = inputLevel;
    }

    protected int calculateInputLevel() {
        return 0;
    }

    public final boolean updateInputLevel() {
        if (this.getInputChannel() == -1) {
            return false;
        }
        if (this.inputChangedThisTick) {
            this.inputUpdateQueued = true;
            return false;
        }
        int in = this.calculateInputLevel();
        if (in != this.inputLevel) {
            this.inputLevel = in;
            this.inputChangedThisTick = true;
            this.onInputLevelChange(in);
            this.notifyInputLevelsChanged(this.getInputChannel());
            return true;
        }
        return false;
    }

    protected void onInputLevelChange(int level) {
    }

    protected final byte[] fetchNetworkInputLevels() {
        byte[] levels = new byte[16];
        for (AbstractTubeModule module : ModuleNetworkManager.getInstance(this.getTube().nonNullLevel()).getConnectedModules(this)) {
            int level;
            AbstractNetworkedRedstoneModule rsModule;
            int inChannel;
            if (!(module instanceof AbstractNetworkedRedstoneModule) || (inChannel = (rsModule = (AbstractNetworkedRedstoneModule)module).getInputChannel()) == -1 || (level = rsModule.inputLevel) <= levels[inChannel]) continue;
            levels[inChannel] = (byte)level;
        }
        return levels;
    }

    protected final void notifyInputLevelsChanged(int channel) {
        byte[] levels = this.fetchNetworkInputLevels();
        for (AbstractTubeModule module : ModuleNetworkManager.getInstance(this.getTube().nonNullLevel()).getConnectedModules(this)) {
            if (!(module instanceof AbstractNetworkedRedstoneModule)) continue;
            AbstractNetworkedRedstoneModule rsModule = (AbstractNetworkedRedstoneModule)module;
            if (channel != -1 && !rsModule.isWatchingChannel(channel)) continue;
            rsModule.updateOutput(levels);
        }
    }

    protected boolean isWatchingChannel(int channel) {
        return false;
    }

    protected void updateOutput(@Nullable byte[] levels) {
    }

    public static void onNetworkReform(Level level, BlockPos pos) {
        if (level.m_5776_()) {
            return;
        }
        ModuleNetworkManager netManager = ModuleNetworkManager.getInstance(level);
        Set<AbstractTubeModule> modules = netManager.computeConnections(level, pos);
        for (Direction dir : Direction.values()) {
            modules.addAll(netManager.computeConnections(level, pos.m_121945_(dir)));
        }
        modules.forEach(module -> {
            if (module instanceof AbstractNetworkedRedstoneModule) {
                AbstractNetworkedRedstoneModule rsModule = (AbstractNetworkedRedstoneModule)module;
                rsModule.notifyInputLevelsChanged(-1);
            }
        });
    }

    @Override
    public final boolean canConnectTo(AbstractTubeModule other) {
        return other instanceof AbstractNetworkedRedstoneModule;
    }

    @Override
    public void onPlaced() {
        super.onPlaced();
        this.updateOutput(null);
    }
}

