/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.datagen;

import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import me.desht.pneumaticcraft.datagen.ModAdvancementProvider;
import me.desht.pneumaticcraft.datagen.ModBiomeTagsProvider;
import me.desht.pneumaticcraft.datagen.ModBlockTagsProvider;
import me.desht.pneumaticcraft.datagen.ModDamageTypeProvider;
import me.desht.pneumaticcraft.datagen.ModDamageTypeTagsProvider;
import me.desht.pneumaticcraft.datagen.ModEntityTypeTagsProvider;
import me.desht.pneumaticcraft.datagen.ModFluidTagsProvider;
import me.desht.pneumaticcraft.datagen.ModGLMProvider;
import me.desht.pneumaticcraft.datagen.ModItemTagsProvider;
import me.desht.pneumaticcraft.datagen.ModLootTablesProvider;
import me.desht.pneumaticcraft.datagen.ModPoiTypeTagsProvider;
import me.desht.pneumaticcraft.datagen.ModRecipeProvider;
import me.desht.pneumaticcraft.datagen.ModStructureTagsProvider;
import me.desht.pneumaticcraft.datagen.ModWorldGenProvider;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.DatapackBuiltinEntriesProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="pneumaticcraft", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new ModRecipeProvider(generator));
        generator.addProvider(event.includeServer(), (DataProvider)new ModLootTablesProvider(generator));
        ModBlockTagsProvider blockTagsProvider = new ModBlockTagsProvider(generator, lookupProvider, existingFileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTagsProvider);
        generator.addProvider(event.includeServer(), (DataProvider)new ModItemTagsProvider(generator, lookupProvider, blockTagsProvider.m_274426_(), existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModFluidTagsProvider(generator, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModBiomeTagsProvider(generator, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModEntityTypeTagsProvider(generator, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModAdvancementProvider(generator, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModGLMProvider(generator));
        generator.addProvider(event.includeServer(), (DataProvider)new ModPoiTypeTagsProvider(generator, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModStructureTagsProvider(generator, lookupProvider, event.getExistingFileHelper()));
        DataGenerators.makeProviders(generator.getPackOutput(), lookupProvider, existingFileHelper).forEach(p -> generator.addProvider(event.includeServer(), p));
    }

    public static List<DataProvider> makeProviders(PackOutput output, CompletableFuture<HolderLookup.Provider> vanillaRegistries, ExistingFileHelper efh) {
        RegistrySetBuilder builder = new RegistrySetBuilder().m_254916_(Registries.f_256911_, ModWorldGenProvider.ConfiguredFeatures::bootstrap).m_254916_(Registries.f_256988_, ModWorldGenProvider.PlacedFeatures::bootstrap).m_254916_(ForgeRegistries.Keys.BIOME_MODIFIERS, ModWorldGenProvider.BiomeModifiers::bootstrap).m_254916_(Registries.f_268580_, ModDamageTypeProvider::bootstrap);
        return List.of(new DatapackBuiltinEntriesProvider(output, vanillaRegistries, builder, Set.of("pneumaticcraft")), new ModDamageTypeTagsProvider(output, (CompletableFuture<HolderLookup.Provider>)vanillaRegistries.thenApply(provider -> DataGenerators.append(provider, builder)), efh));
    }

    private static HolderLookup.Provider append(HolderLookup.Provider original, RegistrySetBuilder builder) {
        return builder.m_254929_((RegistryAccess)RegistryAccess.m_206165_((Registry)BuiltInRegistries.f_257047_), original);
    }
}

