/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.ignition.config;

import com.mrbysco.ignition.Ignition;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class IgnitionConfig {
    public static final ModConfigSpec commonSpec;
    public static final Common COMMON;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        Ignition.LOGGER.debug("Loaded Ignition's config file {}", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onFileChange(ModConfigEvent.Reloading configEvent) {
        Ignition.LOGGER.warn("Ignition's config just got changed on the file system!");
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(Common::new);
        commonSpec = (ModConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ModConfigSpec.BooleanValue enableTorch;
        public final ModConfigSpec.IntValue torchTickDelay;
        public final ModConfigSpec.BooleanValue randomTicking;
        public final ModConfigSpec.BooleanValue enableSoulTorch;
        public final ModConfigSpec.IntValue soulTorchTickDelay;
        public final ModConfigSpec.BooleanValue randomSoulTicking;
        public final ModConfigSpec.BooleanValue enableCampfire;
        public final ModConfigSpec.IntValue campfireTickDelay;
        public final ModConfigSpec.BooleanValue enableSoulCampfire;
        public final ModConfigSpec.IntValue soulCampfireTickDelay;
        public final ModConfigSpec.BooleanValue enableCandles;
        public final ModConfigSpec.IntValue candleTickDelay;
        public final ModConfigSpec.BooleanValue randomCandleTicking;

        Common(ModConfigSpec.Builder builder) {
            builder.comment("General settings").push("General");
            this.enableTorch = builder.comment("Enable Torches setting flammable blocks on fire [Default: true]").define("enableTorch", true);
            this.torchTickDelay = builder.comment("The delay between torch ticks [Default: 60]").defineInRange("torchTickDelay", 60, 1, Integer.MAX_VALUE);
            this.randomTicking = builder.comment("Make the torch ticking completely random [Default: false]").define("randomTicking", false);
            this.enableSoulTorch = builder.comment("Enable Torches setting flammable blocks on fire [Default: true]").define("enableSoulTorch", true);
            this.soulTorchTickDelay = builder.comment("The delay between soul torch ticks [Default: 60]").defineInRange("soulTorchTickDelay", 60, 1, Integer.MAX_VALUE);
            this.randomSoulTicking = builder.comment("Make the soul torch ticking completely random [Default: false]").define("randomSoulTicking", false);
            this.enableCampfire = builder.comment("Enable Campfires setting flammable blocks on fire [Default: true]").define("enableCampfire", true);
            this.campfireTickDelay = builder.comment("The delay between campfire ticks [Default: 60]").defineInRange("campfireTickDelay", 60, 1, Integer.MAX_VALUE);
            this.enableSoulCampfire = builder.comment("Enable Soul Campfires setting flammable blocks on fire [Default: true]").define("enableSoulCampfire", true);
            this.soulCampfireTickDelay = builder.comment("The delay between soul campfire ticks [Default: 60]").defineInRange("soulCampfireTickDelay", 60, 1, Integer.MAX_VALUE);
            this.enableCandles = builder.comment("Enable Candles setting flammable blocks on fire [Default: true]").define("enableCandles", true);
            this.candleTickDelay = builder.comment("The delay between candle ticks [Default: 60]").defineInRange("candleTickDelay", 60, 1, Integer.MAX_VALUE);
            this.randomCandleTicking = builder.comment("Make the candle ticking completely random [Default: false]").define("randomCandleTicking", false);
            builder.pop();
        }
    }
}

