/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.ignition.mixin;

import com.mrbysco.ignition.blocks.Inferno;
import com.mrbysco.ignition.config.IgnitionConfig;
import com.mrbysco.ignition.mixin.BlockBehaviorAccessor;
import com.mrbysco.ignition.util.FlammabilityUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={CandleCakeBlock.class})
public class CandleCakeBlockMixin
extends Block
implements Inferno {
    @Shadow
    @Final
    public static BooleanProperty LIT;

    public CandleCakeBlockMixin(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public boolean ignition$enableFire(BlockState state) {
        return (Boolean)IgnitionConfig.COMMON.enableCandles.get();
    }

    @Override
    public boolean ignition$randomlyTicksFire(BlockState state) {
        return (Boolean)IgnitionConfig.COMMON.randomCandleTicking.get();
    }

    @Override
    public BlockState ignition$getFireState(BlockState state) {
        return Blocks.FIRE.defaultBlockState();
    }

    @Override
    public int ignition$getFireTickDelay(BlockState state, RandomSource rand) {
        return (Integer)IgnitionConfig.COMMON.candleTickDelay.get() + rand.nextInt(10);
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (this.ignition$enableFire(state)) {
            this.ignition$scheduleFireTick((Level)level, pos, state);
            this.ignition$fireTick(state, level, pos, random);
        }
    }

    @Override
    public void ignition$fireTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            FlammabilityUtil.onFireTick(state, (Level)level, pos, random, this.ignition$getFireState(state));
        }
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.onPlace(state, level, pos, oldState, isMoving);
        if (this.ignition$enableFire(state)) {
            if (!this.isRandomlyTicking && this.ignition$randomlyTicksFire(state)) {
                ((BlockBehaviorAccessor)state.getBlock()).setIsRandomlyTicking(true);
            }
            this.ignition$scheduleFireTick(level, pos, state);
        }
    }
}

