/*
 * Decompiled with CFR 0.152.
 */
package com.rosymaple.randomrespawns.mixin;

import com.rosymaple.randomrespawns.CommonConfig;
import java.time.Instant;
import java.util.Optional;
import java.util.Random;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PlayerList.class})
public class PlayerListMixin {
    private static final int MAX_HEIGHT = 256;
    private static final int MIN_HEIGHT = 64;

    @Inject(method={"respawn(Lnet/minecraft/server/level/ServerPlayer;Z)Lnet/minecraft/server/level/ServerPlayer;"}, at={@At(value="HEAD")})
    private void setTimeToZero(ServerPlayer player, boolean keepEverything, CallbackInfoReturnable<ServerPlayer> info) {
        if (((Boolean)CommonConfig.SetTimeToZeroOnRespawn.get()).booleanValue()) {
            player.m_183503_().m_8615_(0L);
        }
        if (((Boolean)CommonConfig.SetWeatherClearOnRespawn.get()).booleanValue()) {
            player.m_183503_().m_8606_(6000, 0, false, false);
        }
    }

    @Redirect(method={"respawn(Lnet/minecraft/server/level/ServerPlayer;Z)Lnet/minecraft/server/level/ServerPlayer;"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;getRespawnPosition()Lnet/minecraft/core/BlockPos;"))
    private BlockPos onGetRespawnPosition(ServerPlayer player) {
        BlockPos pos;
        if (!((Boolean)CommonConfig.EnableRandomRespawns.get()).booleanValue()) {
            return player.m_8961_();
        }
        Random random = player.m_21187_();
        ServerLevel level = player.m_183503_();
        int maxRadius = Math.max(1, (Integer)CommonConfig.RandomRespawnRadius.get());
        int originX = 0;
        int originZ = 0;
        if (((Boolean)CommonConfig.DeathPositionIsOrigin.get()).booleanValue()) {
            originX = player.m_146903_();
            originZ = player.m_146907_();
        }
        long startTime = Instant.now().getEpochSecond();
        do {
            long timeNow;
            int randomX = random.nextInt(originX - maxRadius, originX + maxRadius);
            int randomZ = random.nextInt(originZ - maxRadius, originZ + maxRadius);
            if (((Boolean)CommonConfig.AvoidOceans.get()).booleanValue()) {
                while (level.m_204166_(new BlockPos(randomX, 64, randomZ)).m_203656_(Tags.Biomes.IS_WATER)) {
                    randomX = random.nextInt(originX - maxRadius, originX + maxRadius);
                    randomZ = random.nextInt(originZ - maxRadius, originZ + maxRadius);
                    timeNow = Instant.now().getEpochSecond();
                    if (timeNow - startTime < 10L) continue;
                    player.m_6352_((Component)new TranslatableComponent("randomrespawns.message.respawn_time_out"), Util.f_137441_);
                    return this.calculateRespawnPosition(level, 0, 0);
                }
            }
            pos = this.calculateRespawnPosition(level, randomX, randomZ);
            timeNow = Instant.now().getEpochSecond();
            if (timeNow - startTime < 10L) continue;
            player.m_6352_((Component)new TranslatableComponent("randomrespawns.message.respawn_time_out"), Util.f_137441_);
            return this.calculateRespawnPosition(level, 0, 0);
        } while (((Boolean)CommonConfig.AvoidHazardsOnRespawn.get()).booleanValue() && (this.isHazard(level.m_8055_(pos.m_7495_()).m_60734_()) || this.isHazard(level.m_8055_(pos).m_60734_())));
        return pos;
    }

    @Redirect(method={"respawn(Lnet/minecraft/server/level/ServerPlayer;Z)Lnet/minecraft/server/level/ServerPlayer;"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;findRespawnPositionAndUseSpawnBlock(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;FZZ)Ljava/util/Optional;"))
    private Optional<Vec3> onFindRespawnPositionAndUseSpawnBlock(ServerLevel level, BlockPos pos, float f, boolean b1, boolean b2) {
        if (!((Boolean)CommonConfig.EnableRandomRespawns.get()).booleanValue()) {
            return Player.m_36130_((ServerLevel)level, (BlockPos)pos, (float)f, (boolean)b1, (boolean)b2);
        }
        return Optional.of(new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()));
    }

    @Redirect(method={"respawn(Lnet/minecraft/server/level/ServerPlayer;Z)Lnet/minecraft/server/level/ServerPlayer;"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;moveTo(DDDFF)V"))
    private void onMoveTo(ServerPlayer player, double x, double y, double z, float yaw, float pitch) {
        if (!((Boolean)CommonConfig.EnableRandomRespawns.get()).booleanValue()) {
            player.m_7678_(x, y, z, yaw, pitch);
            return;
        }
        player.m_7678_(x + 0.5, y, z + 0.5, yaw, pitch);
    }

    private boolean isHazard(Block block) {
        return block == Blocks.f_49991_ || block == Blocks.f_50128_ || block == Blocks.f_152499_ || block == Blocks.f_50450_ || block == Blocks.f_50083_;
    }

    private BlockPos calculateRespawnPosition(ServerLevel level, int x, int z) {
        BlockPos pos = null;
        int upper = 256;
        int lower = 64;
        while (lower < upper) {
            int middle = (upper + lower) / 2;
            pos = new BlockPos(x, middle, z);
            if (level.m_8055_(pos).m_60734_() == Blocks.f_50016_) {
                upper = middle - 1;
                continue;
            }
            lower = middle + 1;
        }
        return pos;
    }
}

