/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.souls.entity;

import net.mcreator.souls.init.SoulsModEntities;
import net.mcreator.souls.procedures.MeteoritKazhdyiTikPriPoliotieSnariadaProcedure;
import net.mcreator.souls.procedures.MeteoritKoghdaSnariadPopadaietVBlokProcedure;
import net.mcreator.souls.procedures.MeteoritKoghdaSnariadPopadaietVSushchnostProcedure;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class MeteoritEntity
extends AbstractArrow
implements ItemSupplier {
    public static final ItemStack PROJECTILE_ITEM = new ItemStack((ItemLike)Blocks.MAGMA_BLOCK);

    public MeteoritEntity(EntityType<? extends MeteoritEntity> type, Level world) {
        super(type, world, PROJECTILE_ITEM);
    }

    public MeteoritEntity(EntityType<? extends MeteoritEntity> type, double x, double y, double z, Level world) {
        super(type, x, y, z, world, PROJECTILE_ITEM);
    }

    public MeteoritEntity(EntityType<? extends MeteoritEntity> type, LivingEntity entity, Level world) {
        super(type, entity, world, PROJECTILE_ITEM);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack getItem() {
        return PROJECTILE_ITEM;
    }

    protected void doPostHurtEffects(LivingEntity entity) {
        super.doPostHurtEffects(entity);
        entity.setArrowCount(entity.getArrowCount() - 1);
    }

    public void onHitEntity(EntityHitResult entityHitResult) {
        super.onHitEntity(entityHitResult);
        MeteoritKoghdaSnariadPopadaietVSushchnostProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ());
    }

    public void onHitBlock(BlockHitResult blockHitResult) {
        super.onHitBlock(blockHitResult);
        MeteoritKoghdaSnariadPopadaietVBlokProcedure.execute((LevelAccessor)this.level(), blockHitResult.getBlockPos().getX(), blockHitResult.getBlockPos().getY(), blockHitResult.getBlockPos().getZ());
    }

    public void tick() {
        super.tick();
        MeteoritKazhdyiTikPriPoliotieSnariadaProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ());
        if (this.inGround) {
            this.discard();
        }
    }

    public static MeteoritEntity shoot(Level world, LivingEntity entity, RandomSource source) {
        return MeteoritEntity.shoot(world, entity, source, 1.0f, 5.0, 5);
    }

    public static MeteoritEntity shoot(Level world, LivingEntity entity, RandomSource random, float power, double damage, int knockback) {
        MeteoritEntity entityarrow = new MeteoritEntity((EntityType<? extends MeteoritEntity>)((EntityType)SoulsModEntities.METEORIT.get()), entity, world);
        entityarrow.shoot(entity.getViewVector((float)1.0f).x, entity.getViewVector((float)1.0f).y, entity.getViewVector((float)1.0f).z, power * 2.0f, 0.0f);
        entityarrow.setSilent(true);
        entityarrow.setCritArrow(true);
        entityarrow.setBaseDamage(damage);
        entityarrow.setKnockback(knockback);
        world.addFreshEntity((Entity)entityarrow);
        return entityarrow;
    }

    public static MeteoritEntity shoot(LivingEntity entity, LivingEntity target) {
        MeteoritEntity entityarrow = new MeteoritEntity((EntityType<? extends MeteoritEntity>)((EntityType)SoulsModEntities.METEORIT.get()), entity, entity.level());
        double dx = target.getX() - entity.getX();
        double dy = target.getY() + (double)target.getEyeHeight() - 1.1;
        double dz = target.getZ() - entity.getZ();
        entityarrow.shoot(dx, dy - entityarrow.getY() + Math.hypot(dx, dz) * (double)0.2f, dz, 2.0f, 12.0f);
        entityarrow.setSilent(true);
        entityarrow.setBaseDamage(5.0);
        entityarrow.setKnockback(5);
        entityarrow.setCritArrow(true);
        entity.level().addFreshEntity((Entity)entityarrow);
        return entityarrow;
    }
}

