/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.souls.entity;

import net.mcreator.souls.init.SoulsModEntities;
import net.mcreator.souls.procedures.StrelagpskillKazhdyiTikPriPoliotieSnariadaProcedure;
import net.mcreator.souls.procedures.StrelagpskillKoghdaSnariadPopadaietVBlokProcedure;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class StrelagpskillEntity
extends AbstractArrow
implements ItemSupplier {
    public static final ItemStack PROJECTILE_ITEM = new ItemStack((ItemLike)Blocks.END_ROD);

    public StrelagpskillEntity(EntityType<? extends StrelagpskillEntity> type, Level world) {
        super(type, world, PROJECTILE_ITEM);
    }

    public StrelagpskillEntity(EntityType<? extends StrelagpskillEntity> type, double x, double y, double z, Level world) {
        super(type, x, y, z, world, PROJECTILE_ITEM);
    }

    public StrelagpskillEntity(EntityType<? extends StrelagpskillEntity> type, LivingEntity entity, Level world) {
        super(type, entity, world, PROJECTILE_ITEM);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack getItem() {
        return PROJECTILE_ITEM;
    }

    protected void doPostHurtEffects(LivingEntity entity) {
        super.doPostHurtEffects(entity);
        entity.setArrowCount(entity.getArrowCount() - 1);
    }

    public void onHitEntity(EntityHitResult entityHitResult) {
        super.onHitEntity(entityHitResult);
        StrelagpskillKoghdaSnariadPopadaietVBlokProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ());
    }

    public void onHitBlock(BlockHitResult blockHitResult) {
        super.onHitBlock(blockHitResult);
        StrelagpskillKoghdaSnariadPopadaietVBlokProcedure.execute((LevelAccessor)this.level(), blockHitResult.getBlockPos().getX(), blockHitResult.getBlockPos().getY(), blockHitResult.getBlockPos().getZ());
    }

    public void tick() {
        super.tick();
        StrelagpskillKazhdyiTikPriPoliotieSnariadaProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ());
        if (this.inGround) {
            this.discard();
        }
    }

    public static StrelagpskillEntity shoot(Level world, LivingEntity entity, RandomSource source) {
        return StrelagpskillEntity.shoot(world, entity, source, 0.0f, 0.0, 0);
    }

    public static StrelagpskillEntity shoot(Level world, LivingEntity entity, RandomSource random, float power, double damage, int knockback) {
        StrelagpskillEntity entityarrow = new StrelagpskillEntity((EntityType<? extends StrelagpskillEntity>)((EntityType)SoulsModEntities.STRELAGPSKILL.get()), entity, world);
        entityarrow.shoot(entity.getViewVector((float)1.0f).x, entity.getViewVector((float)1.0f).y, entity.getViewVector((float)1.0f).z, power * 2.0f, 0.0f);
        entityarrow.setSilent(true);
        entityarrow.setCritArrow(false);
        entityarrow.setBaseDamage(damage);
        entityarrow.setKnockback(knockback);
        world.addFreshEntity((Entity)entityarrow);
        return entityarrow;
    }

    public static StrelagpskillEntity shoot(LivingEntity entity, LivingEntity target) {
        StrelagpskillEntity entityarrow = new StrelagpskillEntity((EntityType<? extends StrelagpskillEntity>)((EntityType)SoulsModEntities.STRELAGPSKILL.get()), entity, entity.level());
        double dx = target.getX() - entity.getX();
        double dy = target.getY() + (double)target.getEyeHeight() - 1.1;
        double dz = target.getZ() - entity.getZ();
        entityarrow.shoot(dx, dy - entityarrow.getY() + Math.hypot(dx, dz) * (double)0.2f, dz, 0.0f, 12.0f);
        entityarrow.setSilent(true);
        entityarrow.setBaseDamage(0.0);
        entityarrow.setKnockback(0);
        entityarrow.setCritArrow(false);
        entity.level().addFreshEntity((Entity)entityarrow);
        return entityarrow;
    }
}

