/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.souls.network;

import java.util.HashMap;
import net.mcreator.souls.SoulsMod;
import net.mcreator.souls.procedures.GUIEnderSkill1Procedure;
import net.mcreator.souls.procedures.GUIEnderSkill2Procedure;
import net.mcreator.souls.procedures.GUIEnderSkill3Procedure;
import net.mcreator.souls.procedures.GUIEnderSkill4Procedure;
import net.mcreator.souls.procedures.GUIEnderUltimateProcedure;
import net.mcreator.souls.world.inventory.GUIEnderMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public record GUIEnderButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("souls", "gui_ender_buttons");

    public GUIEnderButtonMessage(FriendlyByteBuf buffer) {
        this(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt());
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.buttonID);
        buffer.writeInt(this.x);
        buffer.writeInt(this.y);
        buffer.writeInt(this.z);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void handleData(GUIEnderButtonMessage message, PlayPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.workHandler().submitAsync(() -> {
                Player entity = (Player)context.player().get();
                int buttonID = message.buttonID;
                int x = message.x;
                int y = message.y;
                int z = message.z;
                GUIEnderButtonMessage.handleButtonAction(entity, buttonID, x, y, z);
            }).exceptionally(e -> {
                context.packetHandler().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        HashMap<String, Object> guistate = GUIEnderMenu.guistate;
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            GUIEnderUltimateProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            GUIEnderSkill1Procedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            GUIEnderSkill2Procedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            GUIEnderSkill4Procedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            GUIEnderSkill3Procedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        SoulsMod.addNetworkMessage(ID, GUIEnderButtonMessage::new, GUIEnderButtonMessage::handleData);
    }
}

