/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.souls.network;

import java.util.HashMap;
import net.mcreator.souls.SoulsMod;
import net.mcreator.souls.procedures.GUISDSkill1Procedure;
import net.mcreator.souls.procedures.GUISDSkill2Procedure;
import net.mcreator.souls.procedures.GUISDSkill3Procedure;
import net.mcreator.souls.procedures.GUISDSkill4Procedure;
import net.mcreator.souls.procedures.GUISDUltimateProcedure;
import net.mcreator.souls.world.inventory.GUISDMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public record GUISDButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("souls", "guisd_buttons");

    public GUISDButtonMessage(FriendlyByteBuf buffer) {
        this(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt());
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.buttonID);
        buffer.writeInt(this.x);
        buffer.writeInt(this.y);
        buffer.writeInt(this.z);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void handleData(GUISDButtonMessage message, PlayPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.workHandler().submitAsync(() -> {
                Player entity = (Player)context.player().get();
                int buttonID = message.buttonID;
                int x = message.x;
                int y = message.y;
                int z = message.z;
                GUISDButtonMessage.handleButtonAction(entity, buttonID, x, y, z);
            }).exceptionally(e -> {
                context.packetHandler().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        HashMap<String, Object> guistate = GUISDMenu.guistate;
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            GUISDSkill3Procedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            GUISDSkill4Procedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            GUISDSkill1Procedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            GUISDUltimateProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            GUISDSkill2Procedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        SoulsMod.addNetworkMessage(ID, GUISDButtonMessage::new, GUISDButtonMessage::handleData);
    }
}

