/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.souls.network;

import java.util.function.Supplier;
import net.mcreator.souls.SoulsMod;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class SoulsModVariables {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"souls");
    public static final Supplier<AttachmentType<PlayerVariables>> PLAYER_VARIABLES = ATTACHMENT_TYPES.register("player_variables", () -> AttachmentType.serializable(() -> new PlayerVariables()).build());

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        SoulsMod.addNetworkMessage(PlayerVariablesSyncMessage.ID, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handleData);
    }

    public record PlayerVariablesSyncMessage(PlayerVariables data) implements CustomPacketPayload
    {
        public static final ResourceLocation ID = new ResourceLocation("souls", "player_variables_sync");

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this(new PlayerVariables());
            this.data.deserializeNBT(buffer.readNbt());
        }

        public void write(FriendlyByteBuf buffer) {
            buffer.writeNbt((Tag)this.data.serializeNBT());
        }

        public ResourceLocation id() {
            return ID;
        }

        public static void handleData(PlayerVariablesSyncMessage message, PlayPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.workHandler().submitAsync(() -> ((PlayerVariables)Minecraft.getInstance().player.getData(PLAYER_VARIABLES)).deserializeNBT(message.data.serializeNBT())).exceptionally(e -> {
                    context.packetHandler().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public static class PlayerVariables
    implements INBTSerializable<CompoundTag> {
        public double ultimateelf = 0.0;
        public double elfskill2 = 0.0;
        public double elfskill1 = 0.0;
        public double elf = 0.0;
        public double ultimatewerewolf = 0.0;
        public double werewolfskill1 = 0.0;
        public double werewolfskill2 = 0.0;
        public double werewolf = 0.0;
        public double dragon = 0.0;
        public double dragonskill1 = 0.0;
        public double dragonskill2 = 0.0;
        public double dragonultimate = 0.0;
        public double cat = 0.0;
        public double catskill1 = 0.0;
        public double catskill2 = 0.0;
        public double catultimate = 0.0;
        public double sd = 0.0;
        public double sdskill1 = 0.0;
        public double sdskill2 = 0.0;
        public double sdultimate = 0.0;
        public double sdskill2procedure = 0.0;
        public double sdultimateprocedure = 0.0;
        public double ghost = 0.0;
        public double ghostskill1 = 0.0;
        public double ghostskill2 = 0.0;
        public double ghostultimate = 0.0;
        public double GP = 0.0;
        public double GPSkill1 = 0.0;
        public double GPSkill2 = 0.0;
        public double GPUltimate = 0.0;
        public double Phantom = 0.0;
        public double PhantomSkill1 = 0.0;
        public double PhantomSkill2 = 0.0;
        public double PhantomUltimate = 0.0;
        public double VoidRasa = 0.0;
        public double VoidSkill1 = 0.0;
        public double VoidSkill2 = 0.0;
        public double VoidUltimate = 0.0;
        public double Ender = 0.0;
        public double EnderSkill1 = 0.0;
        public double EnderSkill2 = 0.0;
        public double EnderUltimate = 0.0;
        public double YY = 0.0;
        public double YYSkill1 = 0.0;
        public double YYSkill2 = 0.0;
        public double YYUltimate = 0.0;
        public double Yeti = 0.0;
        public double YetiSkill1 = 0.0;
        public double YetiSkill2 = 0.0;
        public double YetiUltimate = 0.0;
        public double regen = 0.0;
        public double timberyeti = 0.0;
        public double xender = 0.0;
        public double yender = 0.0;
        public double zender = 0.0;
        public double xuender = 0.0;
        public double yuender = 0.0;
        public double zuender = 0.0;

        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.putDouble("ultimateelf", this.ultimateelf);
            nbt.putDouble("elfskill2", this.elfskill2);
            nbt.putDouble("elfskill1", this.elfskill1);
            nbt.putDouble("elf", this.elf);
            nbt.putDouble("ultimatewerewolf", this.ultimatewerewolf);
            nbt.putDouble("werewolfskill1", this.werewolfskill1);
            nbt.putDouble("werewolfskill2", this.werewolfskill2);
            nbt.putDouble("werewolf", this.werewolf);
            nbt.putDouble("dragon", this.dragon);
            nbt.putDouble("dragonskill1", this.dragonskill1);
            nbt.putDouble("dragonskill2", this.dragonskill2);
            nbt.putDouble("dragonultimate", this.dragonultimate);
            nbt.putDouble("cat", this.cat);
            nbt.putDouble("catskill1", this.catskill1);
            nbt.putDouble("catskill2", this.catskill2);
            nbt.putDouble("catultimate", this.catultimate);
            nbt.putDouble("sd", this.sd);
            nbt.putDouble("sdskill1", this.sdskill1);
            nbt.putDouble("sdskill2", this.sdskill2);
            nbt.putDouble("sdultimate", this.sdultimate);
            nbt.putDouble("sdskill2procedure", this.sdskill2procedure);
            nbt.putDouble("sdultimateprocedure", this.sdultimateprocedure);
            nbt.putDouble("ghost", this.ghost);
            nbt.putDouble("ghostskill1", this.ghostskill1);
            nbt.putDouble("ghostskill2", this.ghostskill2);
            nbt.putDouble("ghostultimate", this.ghostultimate);
            nbt.putDouble("GP", this.GP);
            nbt.putDouble("GPSkill1", this.GPSkill1);
            nbt.putDouble("GPSkill2", this.GPSkill2);
            nbt.putDouble("GPUltimate", this.GPUltimate);
            nbt.putDouble("Phantom", this.Phantom);
            nbt.putDouble("PhantomSkill1", this.PhantomSkill1);
            nbt.putDouble("PhantomSkill2", this.PhantomSkill2);
            nbt.putDouble("PhantomUltimate", this.PhantomUltimate);
            nbt.putDouble("VoidRasa", this.VoidRasa);
            nbt.putDouble("VoidSkill1", this.VoidSkill1);
            nbt.putDouble("VoidSkill2", this.VoidSkill2);
            nbt.putDouble("VoidUltimate", this.VoidUltimate);
            nbt.putDouble("Ender", this.Ender);
            nbt.putDouble("EnderSkill1", this.EnderSkill1);
            nbt.putDouble("EnderSkill2", this.EnderSkill2);
            nbt.putDouble("EnderUltimate", this.EnderUltimate);
            nbt.putDouble("YY", this.YY);
            nbt.putDouble("YYSkill1", this.YYSkill1);
            nbt.putDouble("YYSkill2", this.YYSkill2);
            nbt.putDouble("YYUltimate", this.YYUltimate);
            nbt.putDouble("Yeti", this.Yeti);
            nbt.putDouble("YetiSkill1", this.YetiSkill1);
            nbt.putDouble("YetiSkill2", this.YetiSkill2);
            nbt.putDouble("YetiUltimate", this.YetiUltimate);
            nbt.putDouble("regen", this.regen);
            nbt.putDouble("timberyeti", this.timberyeti);
            nbt.putDouble("xender", this.xender);
            nbt.putDouble("yender", this.yender);
            nbt.putDouble("zender", this.zender);
            nbt.putDouble("xuender", this.xuender);
            nbt.putDouble("yuender", this.yuender);
            nbt.putDouble("zuender", this.zuender);
            return nbt;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.ultimateelf = nbt.getDouble("ultimateelf");
            this.elfskill2 = nbt.getDouble("elfskill2");
            this.elfskill1 = nbt.getDouble("elfskill1");
            this.elf = nbt.getDouble("elf");
            this.ultimatewerewolf = nbt.getDouble("ultimatewerewolf");
            this.werewolfskill1 = nbt.getDouble("werewolfskill1");
            this.werewolfskill2 = nbt.getDouble("werewolfskill2");
            this.werewolf = nbt.getDouble("werewolf");
            this.dragon = nbt.getDouble("dragon");
            this.dragonskill1 = nbt.getDouble("dragonskill1");
            this.dragonskill2 = nbt.getDouble("dragonskill2");
            this.dragonultimate = nbt.getDouble("dragonultimate");
            this.cat = nbt.getDouble("cat");
            this.catskill1 = nbt.getDouble("catskill1");
            this.catskill2 = nbt.getDouble("catskill2");
            this.catultimate = nbt.getDouble("catultimate");
            this.sd = nbt.getDouble("sd");
            this.sdskill1 = nbt.getDouble("sdskill1");
            this.sdskill2 = nbt.getDouble("sdskill2");
            this.sdultimate = nbt.getDouble("sdultimate");
            this.sdskill2procedure = nbt.getDouble("sdskill2procedure");
            this.sdultimateprocedure = nbt.getDouble("sdultimateprocedure");
            this.ghost = nbt.getDouble("ghost");
            this.ghostskill1 = nbt.getDouble("ghostskill1");
            this.ghostskill2 = nbt.getDouble("ghostskill2");
            this.ghostultimate = nbt.getDouble("ghostultimate");
            this.GP = nbt.getDouble("GP");
            this.GPSkill1 = nbt.getDouble("GPSkill1");
            this.GPSkill2 = nbt.getDouble("GPSkill2");
            this.GPUltimate = nbt.getDouble("GPUltimate");
            this.Phantom = nbt.getDouble("Phantom");
            this.PhantomSkill1 = nbt.getDouble("PhantomSkill1");
            this.PhantomSkill2 = nbt.getDouble("PhantomSkill2");
            this.PhantomUltimate = nbt.getDouble("PhantomUltimate");
            this.VoidRasa = nbt.getDouble("VoidRasa");
            this.VoidSkill1 = nbt.getDouble("VoidSkill1");
            this.VoidSkill2 = nbt.getDouble("VoidSkill2");
            this.VoidUltimate = nbt.getDouble("VoidUltimate");
            this.Ender = nbt.getDouble("Ender");
            this.EnderSkill1 = nbt.getDouble("EnderSkill1");
            this.EnderSkill2 = nbt.getDouble("EnderSkill2");
            this.EnderUltimate = nbt.getDouble("EnderUltimate");
            this.YY = nbt.getDouble("YY");
            this.YYSkill1 = nbt.getDouble("YYSkill1");
            this.YYSkill2 = nbt.getDouble("YYSkill2");
            this.YYUltimate = nbt.getDouble("YYUltimate");
            this.Yeti = nbt.getDouble("Yeti");
            this.YetiSkill1 = nbt.getDouble("YetiSkill1");
            this.YetiSkill2 = nbt.getDouble("YetiSkill2");
            this.YetiUltimate = nbt.getDouble("YetiUltimate");
            this.regen = nbt.getDouble("regen");
            this.timberyeti = nbt.getDouble("timberyeti");
            this.xender = nbt.getDouble("xender");
            this.yender = nbt.getDouble("yender");
            this.zender = nbt.getDouble("zender");
            this.xuender = nbt.getDouble("xuender");
            this.yuender = nbt.getDouble("yuender");
            this.zuender = nbt.getDouble("zuender");
        }

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                PacketDistributor.PLAYER.with((Object)serverPlayer).send(new CustomPacketPayload[]{new PlayerVariablesSyncMessage(this)});
            }
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            PlayerVariables original = (PlayerVariables)event.getOriginal().getData(PLAYER_VARIABLES);
            PlayerVariables clone = new PlayerVariables();
            clone.ultimateelf = original.ultimateelf;
            clone.elfskill2 = original.elfskill2;
            clone.elfskill1 = original.elfskill1;
            clone.elf = original.elf;
            clone.ultimatewerewolf = original.ultimatewerewolf;
            clone.werewolfskill1 = original.werewolfskill1;
            clone.werewolfskill2 = original.werewolfskill2;
            clone.werewolf = original.werewolf;
            clone.dragon = original.dragon;
            clone.dragonskill1 = original.dragonskill1;
            clone.dragonskill2 = original.dragonskill2;
            clone.dragonultimate = original.dragonultimate;
            clone.cat = original.cat;
            clone.catskill1 = original.catskill1;
            clone.catskill2 = original.catskill2;
            clone.catultimate = original.catultimate;
            clone.sd = original.sd;
            clone.sdskill1 = original.sdskill1;
            clone.sdskill2 = original.sdskill2;
            clone.sdultimate = original.sdultimate;
            clone.sdskill2procedure = original.sdskill2procedure;
            clone.sdultimateprocedure = original.sdultimateprocedure;
            clone.ghost = original.ghost;
            clone.ghostskill1 = original.ghostskill1;
            clone.ghostskill2 = original.ghostskill2;
            clone.ghostultimate = original.ghostultimate;
            clone.GP = original.GP;
            clone.GPSkill1 = original.GPSkill1;
            clone.GPSkill2 = original.GPSkill2;
            clone.GPUltimate = original.GPUltimate;
            clone.Phantom = original.Phantom;
            clone.PhantomSkill1 = original.PhantomSkill1;
            clone.PhantomSkill2 = original.PhantomSkill2;
            clone.PhantomUltimate = original.PhantomUltimate;
            clone.VoidRasa = original.VoidRasa;
            clone.VoidSkill1 = original.VoidSkill1;
            clone.VoidSkill2 = original.VoidSkill2;
            clone.VoidUltimate = original.VoidUltimate;
            clone.Ender = original.Ender;
            clone.EnderSkill1 = original.EnderSkill1;
            clone.EnderSkill2 = original.EnderSkill2;
            clone.EnderUltimate = original.EnderUltimate;
            clone.YY = original.YY;
            clone.YYSkill1 = original.YYSkill1;
            clone.YYSkill2 = original.YYSkill2;
            clone.YYUltimate = original.YYUltimate;
            clone.Yeti = original.Yeti;
            clone.YetiSkill1 = original.YetiSkill1;
            clone.YetiSkill2 = original.YetiSkill2;
            clone.YetiUltimate = original.YetiUltimate;
            clone.regen = original.regen;
            clone.timberyeti = original.timberyeti;
            clone.xender = original.xender;
            clone.yender = original.yender;
            clone.zender = original.zender;
            clone.xuender = original.xuender;
            clone.yuender = original.yuender;
            clone.zuender = original.zuender;
            if (!event.isWasDeath()) {
                // empty if block
            }
            event.getEntity().setData(PLAYER_VARIABLES, (Object)clone);
        }
    }
}

