/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.blocks.tileentity.types;

import de.maxhenkel.pipez.Filter;
import de.maxhenkel.pipez.FluidFilter;
import de.maxhenkel.pipez.Main;
import de.maxhenkel.pipez.Upgrade;
import de.maxhenkel.pipez.blocks.ModBlocks;
import de.maxhenkel.pipez.blocks.tileentity.PipeLogicTileEntity;
import de.maxhenkel.pipez.blocks.tileentity.PipeTileEntity;
import de.maxhenkel.pipez.blocks.tileentity.UpgradeTileEntity;
import de.maxhenkel.pipez.blocks.tileentity.types.PipeType;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidPipeType
extends PipeType<Fluid> {
    public static final FluidPipeType INSTANCE = new FluidPipeType();

    @Override
    public String getKey() {
        return "Fluid";
    }

    @Override
    public boolean canInsert(BlockEntity tileEntity, Direction direction) {
        return tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, direction).isPresent();
    }

    @Override
    public Filter<Fluid> createFilter() {
        return new FluidFilter();
    }

    @Override
    public String getTranslationKey() {
        return "tooltip.pipez.fluid";
    }

    @Override
    public ItemStack getIcon() {
        return new ItemStack((ItemLike)ModBlocks.FLUID_PIPE);
    }

    @Override
    public Component getTransferText(@Nullable Upgrade upgrade) {
        return new TranslatableComponent("tooltip.pipez.rate.fluid", new Object[]{this.getRate(upgrade)});
    }

    @Override
    public void tick(PipeLogicTileEntity tileEntity) {
        for (Direction side : Direction.values()) {
            IFluidHandler fluidHandler;
            if (!tileEntity.isExtracting(side) || !tileEntity.shouldWork(side, this) || (fluidHandler = this.getFluidHandler(tileEntity, tileEntity.m_58899_().m_142300_(side), side.m_122424_())) == null) continue;
            List<PipeTileEntity.Connection> connections = tileEntity.getSortedConnections(side, this);
            if (tileEntity.getDistribution(side, this).equals(UpgradeTileEntity.Distribution.ROUND_ROBIN)) {
                this.insertEqually(tileEntity, side, connections, fluidHandler);
                continue;
            }
            this.insertOrdered(tileEntity, side, connections, fluidHandler);
        }
    }

    protected void insertEqually(PipeLogicTileEntity tileEntity, Direction side, List<PipeTileEntity.Connection> connections, IFluidHandler fluidHandler) {
        int completeAmount;
        if (connections.isEmpty()) {
            return;
        }
        int mbToTransfer = completeAmount = this.getRate(tileEntity, side);
        boolean[] connectionsFull = new boolean[connections.size()];
        int p = tileEntity.getRoundRobinIndex(side, this) % connections.size();
        while (mbToTransfer > 0 && this.hasNotInserted(connectionsFull)) {
            PipeTileEntity.Connection connection = connections.get(p);
            IFluidHandler destination = this.getFluidHandler(tileEntity, connection.getPos(), connection.getDirection());
            boolean hasInserted = false;
            if (destination != null && !connectionsFull[p]) {
                for (int j = 0; j < fluidHandler.getTanks(); ++j) {
                    FluidStack stack;
                    FluidStack fluidInTank = fluidHandler.getFluidInTank(j);
                    FluidStack simulatedExtract = fluidHandler.drain(new FluidStack(fluidInTank.getFluid(), Math.min(Math.max(completeAmount / FluidPipeType.getConnectionsNotFullCount(connectionsFull), 1), mbToTransfer), fluidInTank.getTag()), IFluidHandler.FluidAction.SIMULATE);
                    if (simulatedExtract.isEmpty() || this.canInsert(connection, simulatedExtract, tileEntity.getFilters(side, this)) == tileEntity.getFilterMode(side, this).equals(UpgradeTileEntity.FilterMode.BLACKLIST) || (stack = FluidUtil.tryFluidTransfer((IFluidHandler)destination, (IFluidHandler)fluidHandler, (FluidStack)simulatedExtract, (boolean)true)).getAmount() <= 0) continue;
                    mbToTransfer -= stack.getAmount();
                    hasInserted = true;
                    break;
                }
            }
            if (!hasInserted) {
                connectionsFull[p] = true;
            }
            p = (p + 1) % connections.size();
        }
        tileEntity.setRoundRobinIndex(side, this, p);
    }

    protected void insertOrdered(PipeLogicTileEntity tileEntity, Direction side, List<PipeTileEntity.Connection> connections, IFluidHandler fluidHandler) {
        int mbToTransfer = this.getRate(tileEntity, side);
        block0: for (PipeTileEntity.Connection connection : connections) {
            IFluidHandler destination = this.getFluidHandler(tileEntity, connection.getPos(), connection.getDirection());
            if (destination == null) continue;
            for (int i = 0; i < fluidHandler.getTanks(); ++i) {
                if (mbToTransfer <= 0) break block0;
                FluidStack fluidInTank = fluidHandler.getFluidInTank(i);
                FluidStack simulatedExtract = fluidHandler.drain(new FluidStack(fluidInTank.getFluid(), mbToTransfer, fluidInTank.getTag()), IFluidHandler.FluidAction.SIMULATE);
                if (simulatedExtract.isEmpty() || this.canInsert(connection, simulatedExtract, tileEntity.getFilters(side, this)) == tileEntity.getFilterMode(side, this).equals(UpgradeTileEntity.FilterMode.BLACKLIST)) continue;
                FluidStack stack = FluidUtil.tryFluidTransfer((IFluidHandler)destination, (IFluidHandler)fluidHandler, (FluidStack)simulatedExtract, (boolean)true);
                mbToTransfer -= stack.getAmount();
            }
        }
    }

    private boolean canInsert(PipeTileEntity.Connection connection, FluidStack stack, List<Filter<?>> filters) {
        for (Filter filter2 : filters.stream().map(filter -> filter).filter(Filter::isInvert).filter(f -> this.matchesConnection(connection, f)).collect(Collectors.toList())) {
            if (!this.matches(filter2, stack)) continue;
            return false;
        }
        List collect = filters.stream().map(filter -> filter).filter(f -> !f.isInvert()).filter(f -> this.matchesConnection(connection, f)).collect(Collectors.toList());
        if (collect.isEmpty()) {
            return true;
        }
        for (Filter filter3 : collect) {
            if (!this.matches(filter3, stack)) continue;
            return true;
        }
        return false;
    }

    private boolean matches(Filter<Fluid> filter, FluidStack stack) {
        CompoundTag metadata = filter.getMetadata();
        if (metadata == null) {
            return filter.getTag() == null || filter.getTag().contains(stack.getFluid());
        }
        if (filter.isExactMetadata()) {
            if (this.deepExactCompare((Tag)metadata, (Tag)stack.getTag())) {
                return filter.getTag() == null || filter.getTag().contains(stack.getFluid());
            }
            return false;
        }
        CompoundTag stackNBT = stack.getTag();
        if (stackNBT == null) {
            return metadata.m_128440_() <= 0;
        }
        if (!this.deepFuzzyCompare((Tag)metadata, (Tag)stackNBT)) {
            return false;
        }
        return filter.getTag() == null || filter.getTag().contains(stack.getFluid());
    }

    private boolean hasNotInserted(boolean[] inventoriesFull) {
        for (boolean b : inventoriesFull) {
            if (b) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private IFluidHandler getFluidHandler(PipeLogicTileEntity tileEntity, BlockPos pos, Direction direction) {
        BlockEntity te = tileEntity.m_58904_().m_7702_(pos);
        if (te == null) {
            return null;
        }
        return (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, direction).orElse(null);
    }

    @Override
    public int getRate(@Nullable Upgrade upgrade) {
        if (upgrade == null) {
            return (Integer)Main.SERVER_CONFIG.fluidPipeAmount.get();
        }
        switch (upgrade) {
            case BASIC: {
                return (Integer)Main.SERVER_CONFIG.fluidPipeAmountBasic.get();
            }
            case IMPROVED: {
                return (Integer)Main.SERVER_CONFIG.fluidPipeAmountImproved.get();
            }
            case ADVANCED: {
                return (Integer)Main.SERVER_CONFIG.fluidPipeAmountAdvanced.get();
            }
            case ULTIMATE: {
                return (Integer)Main.SERVER_CONFIG.fluidPipeAmountUltimate.get();
            }
        }
        return Integer.MAX_VALUE;
    }
}

