/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.viewer.impl.emi;

import aztech.modern_industrialization.client.screen.MIHandledScreen;
import aztech.modern_industrialization.compat.viewer.ReiDraggable;
import aztech.modern_industrialization.network.machines.DoSlotDraggingPacket;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.item.ItemVariant;
import aztech.modern_industrialization.util.Simulation;
import dev.emi.emi.api.EmiDragDropHandler;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.Holder;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

class MIDragDropHandler
implements EmiDragDropHandler<Screen> {
    MIDragDropHandler() {
    }

    public boolean dropStack(Screen screen, EmiIngredient ingredient, int mouseX, int mouseY) {
        FluidVariant fluidVariant;
        if (!(screen instanceof MIHandledScreen)) {
            return false;
        }
        MIHandledScreen gui = (MIHandledScreen)screen;
        EmiStack stack = (EmiStack)ingredient.getEmiStacks().get(0);
        Object object = stack.getKey();
        if (object instanceof Fluid) {
            Fluid f = (Fluid)object;
            fluidVariant = FluidVariant.of(new FluidStack((Holder)f.builtInRegistryHolder(), 1, stack.getComponentChanges()));
        } else {
            fluidVariant = null;
        }
        FluidVariant fk = fluidVariant;
        ItemVariant ik = stack.getKey() instanceof Item ? ItemVariant.of(stack.getItemStack()) : null;
        @Nullable GuiEventListener element = gui.getChildAt(mouseX, mouseY).orElse(null);
        if (element instanceof ReiDraggable) {
            ReiDraggable dw = (ReiDraggable)element;
            if (ik != null) {
                return dw.dragItem(ik, Simulation.ACT);
            }
            if (fk != null) {
                return dw.dragFluid(fk, Simulation.ACT);
            }
        }
        AbstractContainerMenu handler = gui.getMenu();
        Slot slot = gui.getFocusedSlot();
        if (slot instanceof ReiDraggable) {
            ReiDraggable dw = (ReiDraggable)slot;
            int slotId = handler.slots.indexOf((Object)slot);
            if (ik != null && dw.dragItem(ik, Simulation.ACT)) {
                new DoSlotDraggingPacket(handler.containerId, slotId, ik).sendToServer();
                return true;
            }
            if (fk != null && dw.dragFluid(fk, Simulation.ACT)) {
                new DoSlotDraggingPacket(handler.containerId, slotId, fk).sendToServer();
                return true;
            }
        }
        return false;
    }

    public void render(Screen screen, EmiIngredient ingredient, GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        ReiDraggable dw;
        FluidVariant fluidVariant;
        if (!(screen instanceof MIHandledScreen)) {
            return;
        }
        MIHandledScreen gui = (MIHandledScreen)screen;
        ArrayList<Rect2i> bounds = new ArrayList<Rect2i>();
        EmiStack stack = (EmiStack)ingredient.getEmiStacks().get(0);
        Iterator iterator = stack.getKey();
        if (iterator instanceof Fluid) {
            Fluid f = (Fluid)iterator;
            fluidVariant = FluidVariant.of(new FluidStack((Holder)f.builtInRegistryHolder(), 1, stack.getComponentChanges()));
        } else {
            fluidVariant = null;
        }
        FluidVariant fk = fluidVariant;
        ItemVariant ik = stack.getKey() instanceof Item ? ItemVariant.of(stack.getItemStack()) : null;
        for (GuiEventListener element : gui.children()) {
            if (!(element instanceof AbstractWidget)) continue;
            AbstractWidget cw = (AbstractWidget)element;
            if (!(element instanceof ReiDraggable)) continue;
            dw = (ReiDraggable)element;
            if (ik != null && dw.dragItem(ik, Simulation.SIMULATE)) {
                bounds.add(MIDragDropHandler.getWidgetBounds(cw));
            }
            if (fk == null || !dw.dragFluid(fk, Simulation.SIMULATE)) continue;
            bounds.add(MIDragDropHandler.getWidgetBounds(cw));
        }
        AbstractContainerMenu handler = gui.getMenu();
        for (Slot slot : handler.slots) {
            if (!(slot instanceof ReiDraggable)) continue;
            dw = (ReiDraggable)slot;
            if (ik != null && dw.dragItem(ik, Simulation.SIMULATE)) {
                bounds.add(MIDragDropHandler.getSlotBounds(slot, gui));
            }
            if (fk == null || !dw.dragFluid(fk, Simulation.SIMULATE)) continue;
            bounds.add(MIDragDropHandler.getSlotBounds(slot, gui));
        }
        for (Rect2i b : bounds) {
            guiGraphics.fill(b.getX(), b.getY(), b.getX() + b.getWidth(), b.getY() + b.getHeight(), -2010989773);
        }
    }

    private static Rect2i getWidgetBounds(AbstractWidget cw) {
        return new Rect2i(cw.getX(), cw.getY(), cw.getWidth(), cw.getHeight());
    }

    private static Rect2i getSlotBounds(Slot slot, MIHandledScreen<?> screen) {
        return new Rect2i(slot.x + screen.getX(), slot.y + screen.getY(), 16, 16);
    }
}

