/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.definition;

import aztech.modern_industrialization.MIBlock;
import aztech.modern_industrialization.MIFluids;
import aztech.modern_industrialization.MIItem;
import aztech.modern_industrialization.definition.Definition;
import aztech.modern_industrialization.definition.FluidLike;
import aztech.modern_industrialization.definition.FluidTexture;
import aztech.modern_industrialization.definition.ItemDefinition;
import aztech.modern_industrialization.fluid.MIBucketItem;
import aztech.modern_industrialization.fluid.MIFluid;
import aztech.modern_industrialization.fluid.MIFluidBlock;
import aztech.modern_industrialization.fluid.MIFluidType;
import aztech.modern_industrialization.items.SortOrder;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import java.util.function.Supplier;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;

public class FluidDefinition
extends Definition
implements FluidLike {
    public static final int LOW_OPACITY = 180;
    public static final int FULL_OPACITY = 255;
    public static final int NEAR_OPACITY = 240;
    public static final int MEDIUM_OPACITY = 230;
    private final DeferredHolder<Fluid, MIFluid> fluid;
    private DeferredBlock<MIFluidBlock> fluidBlock;
    private ItemDefinition<MIBucketItem> bucketItemDefinition;
    private DeferredHolder<FluidType, MIFluidType> fluidType;
    public final int color;
    public final int opacity;
    public final boolean isGas;
    public final FluidTexture fluidTexture;

    public FluidDefinition(String englishName, String id, int color, int opacity, FluidTexture texture, boolean isGas) {
        super(englishName, id);
        this.color = color;
        this.isGas = isGas;
        this.fluid = MIFluids.FLUIDS.register(id, () -> new MIFluid((Supplier<MIFluidBlock>)this.fluidBlock, this.bucketItemDefinition, (Supplier<MIFluidType>)this.fluidType, color));
        this.fluidBlock = MIBlock.BLOCKS.register(id, () -> new MIFluidBlock(color));
        this.bucketItemDefinition = MIItem.item(englishName + " Bucket", id + "_bucket", s -> new MIBucketItem((MIFluid)((Object)((Object)this.fluid.get())), color, (Item.Properties)s), SortOrder.BUCKETS);
        this.fluidType = MIFluids.FLUID_TYPES.register(id, () -> {
            FluidType.Properties props = FluidType.Properties.create().descriptionId(((MIFluidBlock)((Object)((Object)this.fluidBlock.get()))).getDescriptionId());
            if (isGas) {
                props.density(-1000);
            }
            return new MIFluidType(this.fluidBlock, props);
        });
        this.fluidTexture = texture;
        this.opacity = opacity;
    }

    @Override
    public String getTranslationKey() {
        return "block.modern_industrialization." + this.getId().getPath();
    }

    @Override
    public Fluid asFluid() {
        return (Fluid)this.fluid.get();
    }

    public MIFluidBlock asFluidBlock() {
        return (MIFluidBlock)((Object)this.fluidBlock.get());
    }

    public BucketItem getBucket() {
        return this.bucketItemDefinition.asItem();
    }

    public FluidVariant variant() {
        return FluidVariant.of(this.asFluid());
    }
}

