/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines;

import aztech.modern_industrialization.MITags;
import aztech.modern_industrialization.client.MIRenderTypes;
import aztech.modern_industrialization.machines.MachineBlock;
import aztech.modern_industrialization.machines.MachineOverlay;
import aztech.modern_industrialization.thirdparty.fabricrendering.QuadBuffer;
import aztech.modern_industrialization.util.GeometryHelper;
import aztech.modern_industrialization.util.RenderHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;
import org.joml.Matrix4f;

public class MachineOverlayClient {
    public static void onBlockOutline(RenderHighlightEvent.Block event) {
        BlockHitResult blockHitResult = event.getTarget();
        BlockPos pos = blockHitResult.getBlockPos();
        BlockState state = Minecraft.getInstance().level.getBlockState(pos);
        if (state.getBlock() instanceof MachineBlock && Minecraft.getInstance().player.getMainHandItem().is(MITags.WRENCHES)) {
            PoseStack poseStack = event.getPoseStack();
            poseStack.pushPose();
            Vec3 cameraPos = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
            double x = (double)pos.getX() - cameraPos.x;
            double y = (double)pos.getY() - cameraPos.y;
            double z = (double)pos.getZ() - cameraPos.z;
            poseStack.translate(x, y, z);
            Vec3 posInBlock = MachineOverlay.getPosInBlock(blockHitResult);
            Vec3 posOnFace = GeometryHelper.toFaceCoords(posInBlock, blockHitResult.getDirection());
            QuadBuffer emitter = new QuadBuffer();
            VertexConsumer vc = event.getMultiBufferSource().getBuffer(MIRenderTypes.machineOverlay());
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    double minX = MachineOverlay.ZONES[i];
                    double maxX = MachineOverlay.ZONES[i + 1];
                    double minY = MachineOverlay.ZONES[j];
                    double maxY = MachineOverlay.ZONES[j + 1];
                    boolean insideQuad = minX <= posOnFace.x && posOnFace.x <= maxX && minY <= posOnFace.y && posOnFace.y <= maxY;
                    emitter.emit();
                    emitter.square(blockHitResult.getDirection(), (float)minX, (float)minY, (float)maxX, (float)maxY, -3.5E-4f);
                    float r = 0.0f;
                    float g = insideQuad ? 1.0f : 0.0f;
                    float b = insideQuad ? 0.0f : 1.0f;
                    RenderHelper.quadWithAlpha(vc, poseStack.last(), emitter.toBakedQuad(null), r, g, b, 0.3f, Integer.MAX_VALUE, -2130706433);
                }
            }
            Minecraft.getInstance().renderBuffers().bufferSource().endBatch(MIRenderTypes.machineOverlay());
            VertexConsumer lines = event.getMultiBufferSource().getBuffer(RenderType.lines());
            Matrix4f model = poseStack.last().pose();
            Direction face = blockHitResult.getDirection();
            MachineOverlayClient.vertex(model, lines, face, MachineOverlay.ZONES[1], MachineOverlay.ZONES[0]);
            MachineOverlayClient.vertex(model, lines, face, MachineOverlay.ZONES[1], MachineOverlay.ZONES[3]);
            MachineOverlayClient.vertex(model, lines, face, MachineOverlay.ZONES[2], MachineOverlay.ZONES[0]);
            MachineOverlayClient.vertex(model, lines, face, MachineOverlay.ZONES[2], MachineOverlay.ZONES[3]);
            MachineOverlayClient.vertex(model, lines, face, MachineOverlay.ZONES[0], MachineOverlay.ZONES[1]);
            MachineOverlayClient.vertex(model, lines, face, MachineOverlay.ZONES[3], MachineOverlay.ZONES[1]);
            MachineOverlayClient.vertex(model, lines, face, MachineOverlay.ZONES[0], MachineOverlay.ZONES[2]);
            MachineOverlayClient.vertex(model, lines, face, MachineOverlay.ZONES[3], MachineOverlay.ZONES[2]);
            poseStack.popPose();
        }
    }

    private static void vertex(Matrix4f model, VertexConsumer lines, Direction face, double faceX, double faceY) {
        Vec3 coord = GeometryHelper.toWorldCoords(new Vec3(faceX, faceY, 0.0), face);
        lines.addVertex(model, (float)coord.x, (float)coord.y, (float)coord.z).setColor(0.0f, 0.0f, 0.0f, 0.4f).setNormal(0.0f, 0.0f, 0.0f);
    }
}

