/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.blockentities;

import aztech.modern_industrialization.inventory.ConfigurableItemStack;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.inventory.SlotPositions;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.guicomponents.AutoExtract;
import aztech.modern_industrialization.machines.models.MachineCasings;
import aztech.modern_industrialization.machines.models.MachineModelClientData;
import aztech.modern_industrialization.util.Tickable;
import java.util.ArrayList;
import java.util.Collections;

public class ConfigurableChestMachineBlockEntity
extends MachineBlockEntity
implements Tickable {
    private final MIInventory inventory;

    public ConfigurableChestMachineBlockEntity(BEP bep) {
        super(bep, new MachineGuiParameters.Builder("configurable_chest", true).backgroundHeight(180).build(), new OrientationComponent.Params(true, true, false));
        ArrayList<ConfigurableItemStack> stacks = new ArrayList<ConfigurableItemStack>();
        for (int i = 0; i < 27; ++i) {
            stacks.add(ConfigurableItemStack.standardIOSlot(true));
        }
        SlotPositions itemPositions = new SlotPositions.Builder().addSlots(8, 30, 9, 3).build();
        this.inventory = new MIInventory(stacks, Collections.emptyList(), itemPositions, SlotPositions.empty());
        this.registerGuiComponent(new AutoExtract.Server(this.orientation));
        this.registerComponents(this.inventory);
    }

    @Override
    public MIInventory getInventory() {
        return this.inventory;
    }

    @Override
    protected MachineModelClientData getMachineModelData() {
        MachineModelClientData data = new MachineModelClientData(MachineCasings.STEEL_CRATE);
        this.orientation.writeModelData(data);
        return data;
    }

    @Override
    public void tick() {
        if (!this.level.isClientSide() && this.orientation.extractItems) {
            this.inventory.autoExtractItems(this.level, this.worldPosition, this.orientation.outputDirection);
        }
    }
}

