/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.multiblocks;

import aztech.modern_industrialization.machines.multiblocks.HatchType;
import java.util.HashSet;
import java.util.Set;

public class HatchFlags {
    public static final HatchFlags NO_HATCH = new Builder().build();
    private final Set<HatchType> allowed;

    public HatchFlags(Set<HatchType> allowed) {
        this.allowed = Set.copyOf(allowed);
    }

    public boolean allows(HatchType type) {
        return this.allowed.contains(type);
    }

    public Set<HatchType> values() {
        return this.allowed;
    }

    public static class Builder {
        private final Set<HatchType> allowed = new HashSet<HatchType>();

        public Builder with(HatchType type) {
            this.allowed.add(type);
            return this;
        }

        public Builder with(HatchType ... types) {
            for (HatchType type : types) {
                this.with(type);
            }
            return this;
        }

        public HatchFlags build() {
            return new HatchFlags(this.allowed);
        }
    }
}

