/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.recipe.condition;

import aztech.modern_industrialization.MIItem;
import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.machines.recipe.MachineRecipe;
import aztech.modern_industrialization.machines.recipe.condition.MachineProcessCondition;
import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public record DimensionProcessCondition(ResourceKey<Level> dimension) implements MachineProcessCondition
{
    static final MapCodec<DimensionProcessCondition> CODEC = ResourceKey.codec((ResourceKey)Registries.DIMENSION).fieldOf("dimension").xmap(DimensionProcessCondition::new, DimensionProcessCondition::dimension);
    static final StreamCodec<RegistryFriendlyByteBuf, DimensionProcessCondition> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceKey.streamCodec((ResourceKey)Registries.DIMENSION), DimensionProcessCondition::dimension, DimensionProcessCondition::new);

    @Override
    public boolean canProcessRecipe(MachineProcessCondition.Context context, MachineRecipe recipe) {
        return context.getLevel().dimension() == this.dimension;
    }

    @Override
    public void appendDescription(List<Component> list) {
        ResourceLocation loc = this.dimension.location();
        MutableComponent dimComponent = Component.translatable((String)"dimension.%s.%s".formatted(loc.getNamespace(), loc.getPath()));
        list.add((Component)MIText.RequiresDimension.text(dimComponent));
    }

    @Override
    public ItemStack icon() {
        return MIItem.SINGULARITY.asItem().getDefaultInstance();
    }

    @Override
    public MapCodec<? extends MachineProcessCondition> codec() {
        return CODEC;
    }

    @Override
    public StreamCodec<? super RegistryFriendlyByteBuf, ? extends MachineProcessCondition> streamCodec() {
        return STREAM_CODEC;
    }
}

