/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.blocks.prism;

import alexthw.ars_elemental.common.blocks.prism.AdvancedPrismTile;
import com.alexthw.sauce.api.item.SpellPrismLens;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.advancement.ANCriteriaTriggers;
import com.hollingsworth.arsnouveau.common.block.SpellPrismBlock;
import com.hollingsworth.arsnouveau.common.entity.EntityProjectileSpell;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdvancedPrism
extends SpellPrismBlock
implements EntityBlock {
    static final SpellPrismLens defaultLent = (spell, level, pos) -> true;

    public AdvancedPrism(BlockBehaviour.Properties blockProps) {
        super(blockProps.noOcclusion());
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState pState) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        BlockEntity blockEntity;
        if (!player.level().isClientSide && stack.getItem() instanceof SpellPrismLens && (blockEntity = level.getBlockEntity(pos)) instanceof AdvancedPrismTile) {
            AdvancedPrismTile tile = (AdvancedPrismTile)blockEntity;
            tile.setLens(stack.split(1), player);
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public void onHit(ServerLevel world, BlockPos pos, EntityProjectileSpell spell) {
        SpellPrismLens lens;
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (!(blockEntity instanceof AdvancedPrismTile)) {
            return;
        }
        AdvancedPrismTile tile = (AdvancedPrismTile)blockEntity;
        Position iposition = this.getDispensePosition(pos, tile.getShootAngle());
        spell.setPos(iposition.x(), iposition.y(), iposition.z());
        ++spell.prismRedirect;
        if (spell.prismRedirect >= 3) {
            ANCriteriaTriggers.rewardNearbyPlayers((PlayerTrigger)((PlayerTrigger)ANCriteriaTriggers.PRISMATIC.get()), (ServerLevel)world, (BlockPos)pos, (int)10);
        }
        if (spell.resolver() == null) {
            spell.remove(Entity.RemovalReason.DISCARDED);
            return;
        }
        Vec3 vec3d = tile.getShootAngle();
        Item item = tile.getLens().getItem();
        if (item instanceof SpellPrismLens && (lens = (SpellPrismLens)item).canConvert(spell, (Level)world, pos)) {
            lens.shoot(world, pos, spell, vec3d);
        } else {
            defaultLent.shoot(world, pos, spell, vec3d);
        }
        BlockUtil.updateObservers((Level)world, (BlockPos)pos);
    }

    public Position getDispensePosition(BlockPos blockPos, Vec3 direction) {
        Vec3 coords = Vec3.atCenterOf((Vec3i)blockPos);
        double d0 = coords.x() + 0.5 * direction.x();
        double d1 = coords.y() + 0.5 * direction.y();
        double d2 = coords.z() + 0.5 * direction.z();
        return new Vec3(d0, d1, d2);
    }

    public void setPlacedBy(Level world, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack stack) {
        Direction orientation = placer == null ? Direction.WEST : Direction.orderedByNearest((Entity)placer)[0].getOpposite();
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (!(blockEntity instanceof AdvancedPrismTile)) {
            return;
        }
        AdvancedPrismTile prismTile = (AdvancedPrismTile)blockEntity;
        switch (orientation) {
            case DOWN: {
                prismTile.rotationY = -90.0f;
                break;
            }
            case UP: {
                prismTile.rotationY = 90.0f;
                break;
            }
            case NORTH: {
                prismTile.rotationX = 270.0f;
                break;
            }
            case SOUTH: {
                prismTile.rotationX = 90.0f;
                break;
            }
            case WEST: {
                break;
            }
            case EAST: {
                prismTile.rotationX = 180.0f;
            }
        }
    }

    @NotNull
    public BlockState rotate(@NotNull BlockState state, LevelAccessor level, @NotNull BlockPos pos, @NotNull Rotation rot) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof AdvancedPrismTile) {
            AdvancedPrismTile prismTile = (AdvancedPrismTile)blockEntity;
            float f = prismTile.getRotationX();
            prismTile.setRotX(f + (switch (rot) {
                default -> throw new MatchException(null, null);
                case Rotation.NONE -> 0.0f;
                case Rotation.CLOCKWISE_90 -> 90.0f;
                case Rotation.CLOCKWISE_180 -> 180.0f;
                case Rotation.COUNTERCLOCKWISE_90 -> -90.0f;
            }));
            prismTile.updateBlock();
        }
        return super.rotate(state, level, pos, rot);
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        return new AdvancedPrismTile(pPos, pState);
    }
}

