/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.rituals.forest;

import alexthw.ars_elemental.ArsElemental;
import alexthw.ars_elemental.common.rituals.forest.ArchpodFeature;
import alexthw.ars_elemental.common.rituals.forest.PlaceableLightFeature;
import alexthw.ars_elemental.registry.ModItems;
import com.hollingsworth.arsnouveau.api.ritual.FeaturePlacementRitual;
import com.hollingsworth.arsnouveau.api.ritual.features.BonemealFeature;
import com.hollingsworth.arsnouveau.api.ritual.features.IPlaceableFeature;
import com.hollingsworth.arsnouveau.api.ritual.features.PlaceBlockFeature;
import com.hollingsworth.arsnouveau.api.ritual.features.RandomTreeFeature;
import com.hollingsworth.arsnouveau.common.block.ArchfruitPod;
import com.hollingsworth.arsnouveau.common.block.SourceBerryBush;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SaplingBlock;

public class ArchwoodForestationRitual
extends FeaturePlacementRitual {
    public static final String ID = "ritual_archwood_forestation";
    int biomeType = -1;

    public void addFeatures(List<IPlaceableFeature> features) {
        features.add((IPlaceableFeature)new BonemealFeature(6.0, 0.4));
        switch (this.biomeType) {
            case 0: {
                features.add((IPlaceableFeature)new RandomTreeFeature(List.of(BlockRegistry.BLAZING_SAPLING.defaultBlockState()), 8.0, 0.8));
                features.add((IPlaceableFeature)new PlaceBlockFeature(2.0, 0.1, () -> ((Block)Blocks.TORCHFLOWER).defaultBlockState()));
                features.add(new ArchpodFeature(1.0, 0.15, BlockRegistry.BOMBEGRANTE_POD.defaultBlockState()));
                break;
            }
            case 1: {
                features.add((IPlaceableFeature)new RandomTreeFeature(List.of(BlockRegistry.CASCADING_SAPLING.defaultBlockState()), 8.0, 0.8));
                features.add((IPlaceableFeature)new PlaceBlockFeature(2.0, 0.1, () -> ((Block)Blocks.PITCHER_PLANT).defaultBlockState()));
                features.add(new ArchpodFeature(1.0, 0.15, BlockRegistry.FROSTAYA_POD.defaultBlockState()));
                break;
            }
            case 2: {
                features.add((IPlaceableFeature)new RandomTreeFeature(List.of(BlockRegistry.VEXING_SAPLING.defaultBlockState()), 8.0, 0.8));
                features.add((IPlaceableFeature)new PlaceBlockFeature(2.0, 0.1, () -> ((SourceBerryBush)((SourceBerryBush)BlockRegistry.SOURCEBERRY_BUSH.get())).defaultBlockState()));
                features.add(new ArchpodFeature(1.0, 0.15, BlockRegistry.BASTION_POD.defaultBlockState()));
                break;
            }
            case 3: {
                features.add((IPlaceableFeature)new RandomTreeFeature(List.of(BlockRegistry.FLOURISHING_SAPLING.defaultBlockState()), 8.0, 0.8));
                features.add((IPlaceableFeature)new PlaceBlockFeature(2.0, 0.1, () -> ((Block)((Block)ModItems.GROUND_BLOSSOM.get())).defaultBlockState()));
                features.add(new ArchpodFeature(1.0, 0.15, BlockRegistry.MENDOSTEEN_POD.defaultBlockState()));
                break;
            }
            case 4: {
                features.add((IPlaceableFeature)new RandomTreeFeature(List.of(((Block)ModItems.FLASHING_SAPLING.get()).defaultBlockState()), 8.0, 0.8));
                features.add((IPlaceableFeature)new PlaceBlockFeature(2.0, 0.1, () -> ((Block)((Block)ModItems.SPARKFLOWER.get())).defaultBlockState()));
                features.add(new ArchpodFeature(1.0, 0.15, ((ArchfruitPod)ModItems.FLASHING_POD.get()).defaultBlockState()));
                break;
            }
            default: {
                features.add((IPlaceableFeature)new RandomTreeFeature(List.of(BlockRegistry.BLAZING_SAPLING.defaultBlockState(), BlockRegistry.CASCADING_SAPLING.defaultBlockState(), BlockRegistry.VEXING_SAPLING.defaultBlockState(), BlockRegistry.FLOURISHING_SAPLING.defaultBlockState(), ((Block)ModItems.FLASHING_SAPLING.get()).defaultBlockState()), 8.0, 0.8));
                features.add((IPlaceableFeature)new PlaceBlockFeature(2.0, 0.1, () -> ((SourceBerryBush)((SourceBerryBush)BlockRegistry.SOURCEBERRY_BUSH.get())).defaultBlockState()));
                features.add(new ArchpodFeature(0.5, 0.1, BlockRegistry.BOMBEGRANTE_POD.defaultBlockState()));
                features.add(new ArchpodFeature(0.5, 0.1, BlockRegistry.FROSTAYA_POD.defaultBlockState()));
                features.add(new ArchpodFeature(0.5, 0.1, BlockRegistry.BASTION_POD.defaultBlockState()));
                features.add(new ArchpodFeature(0.5, 0.1, BlockRegistry.MENDOSTEEN_POD.defaultBlockState()));
                features.add(new ArchpodFeature(0.5, 0.1, ((ArchfruitPod)ModItems.FLASHING_POD.get()).defaultBlockState()));
            }
        }
        features.add((IPlaceableFeature)new PlaceableLightFeature(4.0, 0.1));
    }

    public String getLangName() {
        return "Forestation - Archwood";
    }

    public String getLangDescription() {
        return "Places grown Archwood Trees, and applies bonemeal in a 7x7 (circular) area. Augmenting with a source gem will increase the radius by 1 for each gem. Augmenting with a specific archwood sapling will spawn resources tied to its biome.";
    }

    public ResourceLocation getRegistryName() {
        return ArsElemental.prefix(ID);
    }

    public boolean canConsumeItem(ItemStack stack) {
        BlockItem bi;
        Item item;
        boolean isVariant;
        if (this.biomeType != -1) {
            return super.canConsumeItem(stack);
        }
        boolean blazing = stack.getItem() == BlockRegistry.BLAZING_SAPLING.asItem();
        boolean cascading = stack.getItem() == BlockRegistry.CASCADING_SAPLING.asItem();
        boolean flourishing = stack.getItem() == BlockRegistry.FLOURISHING_SAPLING.asItem();
        boolean vexing = stack.getItem() == BlockRegistry.VEXING_SAPLING.asItem();
        boolean flashing = stack.getItem() == ((Block)ModItems.FLASHING_SAPLING.get()).asItem();
        boolean bl = isVariant = blazing || cascading || flourishing || vexing || flashing;
        if (isVariant) {
            if (blazing) {
                this.biomeType = 0;
            }
            if (cascading) {
                this.biomeType = 1;
            }
            if (vexing) {
                this.biomeType = 2;
            }
            if (flourishing) {
                this.biomeType = 3;
            }
            if (flashing) {
                this.biomeType = 4;
            }
        } else {
            this.biomeType = -1;
        }
        return super.canConsumeItem(stack) || isVariant && (item = stack.getItem()) instanceof BlockItem && (bi = (BlockItem)item).getBlock() instanceof SaplingBlock;
    }
}

