/*
 * Decompiled with CFR 0.152.
 */
package com.min01.oceanicrealms;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AESUtil {
    private static final int IV_SIZE = 12;
    private static final int TAG_LENGTH = 128;
    private static final String MASTER_KEY = "leiojgwiojg80";
    private static final String SALT = "12h92h0twhg9o";
    public static final String HEADER = "OCEANICR";
    private static final byte[] MAGIC_HEADER = "OCEANICR".getBytes(StandardCharsets.UTF_8);

    private static SecretKey getMasterKey() throws NoSuchAlgorithmException, InvalidKeySpecException {
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
        PBEKeySpec spec = new PBEKeySpec(MASTER_KEY.toCharArray(), SALT.getBytes(), 65536, 256);
        SecretKey tmp = factory.generateSecret(spec);
        return new SecretKeySpec(tmp.getEncoded(), "AES");
    }

    public static ByteArrayInputStream decryptFile(byte[] encryptedData) throws Exception {
        SecretKey key = AESUtil.getMasterKey();
        ByteBuffer byteBuffer = ByteBuffer.wrap(encryptedData);
        byte[] magic = new byte[MAGIC_HEADER.length];
        byteBuffer.get(magic);
        if (!Arrays.equals(magic, MAGIC_HEADER)) {
            return null;
        }
        byte[] iv = new byte[12];
        byteBuffer.get(iv);
        GCMParameterSpec spec = new GCMParameterSpec(128, iv);
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        cipher.init(2, (Key)key, spec);
        byte[] cipherBytes = new byte[byteBuffer.remaining()];
        byteBuffer.get(cipherBytes);
        byte[] plainBytes = cipher.doFinal(cipherBytes);
        return new ByteArrayInputStream(plainBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void encryptFile(File inputFile, File outputFile) throws Exception {
        SecretKey key = AESUtil.getMasterKey();
        byte[] iv = new byte[12];
        SecureRandom random = new SecureRandom();
        random.nextBytes(iv);
        GCMParameterSpec spec = new GCMParameterSpec(128, iv);
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        cipher.init(1, (Key)key, spec);
        try (FileInputStream fis = new FileInputStream(inputFile);
             FileOutputStream fos = new FileOutputStream(outputFile);){
            int read;
            fos.write(MAGIC_HEADER);
            fos.write(iv);
            byte[] buffer = new byte[1024];
            while ((read = fis.read(buffer)) != -1) {
                byte[] cipherBytes = cipher.update(buffer, 0, read);
                if (cipherBytes == null) continue;
                fos.write(cipherBytes);
            }
            byte[] finalBytes = cipher.doFinal();
            if (finalBytes != null) {
                fos.write(finalBytes);
            }
        }
        finally {
            inputFile.delete();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void encryptFiles(String extension) throws Exception {
        File dir = AESUtil.getOrCreateDirectory("aes");
        File[] files = dir.listFiles(f -> f.isFile() && f.getName().endsWith(extension));
        if (files == null) {
            return;
        }
        for (File file : files) {
            File encryptedFile = new File(file.getParent(), file.getName() + ".dat");
            AESUtil.encryptFile(file, encryptedFile);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static File getOrCreateDirectory(String name) {
        File dir = new File(Minecraft.m_91087_().f_91069_, name);
        if (!dir.exists()) {
            dir.mkdir();
        }
        return dir;
    }
}

