/*
 * Decompiled with CFR 0.152.
 */
package com.min01.oceanicrealms.block;

import com.min01.oceanicrealms.block.OceanicBlocks;
import com.min01.oceanicrealms.blockentity.AnimatableBlockEntity;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class StarfishBlock
extends FaceAttachedHorizontalDirectionalBlock
implements EntityBlock,
SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final IntegerProperty VARIANT = IntegerProperty.m_61631_((String)"starfish_variant", (int)1, (int)9);
    protected static final VoxelShape FLOOR_AABB = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0);
    protected static final VoxelShape CEILING_AABB = Block.m_49796_((double)4.0, (double)14.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    protected static final VoxelShape EAST_AABB = Block.m_49796_((double)0.0, (double)4.0, (double)4.0, (double)2.0, (double)12.0, (double)12.0);
    protected static final VoxelShape NORTH_AABB = Block.m_49796_((double)4.0, (double)4.0, (double)14.0, (double)12.0, (double)12.0, (double)16.0);
    protected static final VoxelShape SOUTH_AABB = Block.m_49796_((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)2.0);
    protected static final VoxelShape WEST_AABB = Block.m_49796_((double)14.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0);

    public StarfishBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60955_().m_60918_(SoundType.f_56750_));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)f_53179_, (Comparable)AttachFace.FLOOR)).m_61124_((Property)VARIANT, (Comparable)Integer.valueOf(1)));
    }

    public RenderShape m_7514_(BlockState p_49232_) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public BlockEntity m_142194_(BlockPos p_153215_, BlockState p_153216_) {
        return new AnimatableBlockEntity(p_153215_, p_153216_);
    }

    public VoxelShape m_5940_(BlockState p_60555_, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        switch ((AttachFace)p_60555_.m_61143_((Property)f_53179_)) {
            case CEILING: {
                return CEILING_AABB;
            }
            case FLOOR: {
                return FLOOR_AABB;
            }
            case WALL: {
                switch ((Direction)p_60555_.m_61143_((Property)f_54117_)) {
                    case EAST: {
                        return EAST_AABB;
                    }
                    case NORTH: {
                        return NORTH_AABB;
                    }
                    case SOUTH: {
                        return SOUTH_AABB;
                    }
                    case WEST: {
                        return WEST_AABB;
                    }
                }
                return FLOOR_AABB;
            }
        }
        return FLOOR_AABB;
    }

    public BlockState m_5573_(BlockPlaceContext p_54302_) {
        BlockState state = super.m_5573_(p_54302_);
        Level level = p_54302_.m_43725_();
        RandomSource random = level.f_46441_;
        FluidState fluidState = p_54302_.m_43725_().m_6425_(p_54302_.m_8083_());
        return state != null ? (BlockState)((BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_205070_(FluidTags.f_13131_)))).m_61124_((Property)VARIANT, (Comparable)Integer.valueOf(random.m_216339_(1, 10))) : state;
    }

    public FluidState m_5888_(BlockState p_152045_) {
        return (Boolean)p_152045_.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : Fluids.f_76191_.m_76145_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_54663_) {
        p_54663_.m_61104_(new Property[]{f_53179_, f_54117_, WATERLOGGED, VARIANT});
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level p_153273_, BlockState p_153274_, BlockEntityType<T> p_153275_) {
        return StarfishBlock.createTicker(p_153273_, p_153275_, (BlockEntityType<AnimatableBlockEntity>)((BlockEntityType)OceanicBlocks.ANIMATABLE_BLOCK_ENTITY.get()));
    }

    @Nullable
    protected static <T extends BlockEntity> BlockEntityTicker<T> createTicker(Level p_151988_, BlockEntityType<T> p_151989_, BlockEntityType<AnimatableBlockEntity> p_151990_) {
        return StarfishBlock.createTickerHelper(p_151989_, p_151990_, AnimatableBlockEntity::update);
    }

    @Nullable
    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> p_152133_, BlockEntityType<E> p_152134_, BlockEntityTicker<? super E> p_152135_) {
        return p_152134_ == p_152133_ ? p_152135_ : null;
    }
}

