/*
 * Decompiled with CFR 0.152.
 */
package com.min01.oceanicrealms.entity;

import com.min01.oceanicrealms.entity.AbstractOceanicCreature;
import com.min01.oceanicrealms.entity.AgeableWaterAnimal;
import com.min01.oceanicrealms.entity.IAvoid;
import com.min01.oceanicrealms.entity.ai.goal.SharkAttackGoal;
import com.min01.oceanicrealms.entity.ai.goal.SharkEatingGoal;
import com.min01.oceanicrealms.util.OceanicUtil;
import java.util.List;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractOceanicShark
extends AbstractOceanicCreature
implements IAvoid {
    public static final EntityDataAccessor<Integer> HUNGER_COOLDOWN = SynchedEntityData.m_135353_(AbstractOceanicShark.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> IS_EAT = SynchedEntityData.m_135353_(AbstractOceanicShark.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public AbstractOceanicShark(EntityType<? extends AgeableWaterAnimal> p_33002_, Level p_33003_) {
        super(p_33002_, p_33003_);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HUNGER_COOLDOWN, (Object)0);
        this.f_19804_.m_135372_(IS_EAT, (Object)false);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(4, (Goal)new SharkEatingGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new SharkAttackGoal(this));
        this.f_21346_.m_25352_(4, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.isUsingSkill()) {
            float size = this.getHeadSize();
            Vec3 lookPos = OceanicUtil.getLookPos(this.m_20155_(), this.m_20182_(), 0.0, 0.0, this.getHeadDistance());
            AABB aabb = new AABB((double)(-size), (double)(-size), (double)(-size), (double)size, (double)this.getYHeadSize(), (double)size).m_82383_(lookPos);
            List list = this.f_19853_.m_6443_(ItemEntity.class, aabb, item -> {
                boolean flag = item.m_32055_().getFoodProperties((LivingEntity)this) != null && item.m_32055_().getFoodProperties((LivingEntity)this).m_38746_();
                return item.m_32055_().m_204117_(ItemTags.f_13156_) || flag;
            });
            if (!list.isEmpty()) {
                ItemEntity item2 = (ItemEntity)list.get(0);
                this.setAnimationState(2);
                this.setAnimationTick(20);
                this.m_216990_(SoundEvents.f_12321_);
                item2.m_146870_();
            }
        }
        if (this.getAnimationTick() <= 0 && this.getAnimationState() == 2) {
            this.setAnimationState(0);
        }
        if (this.m_5448_() != null) {
            if (this.canMove()) {
                this.m_21573_().m_5624_((Entity)this.m_5448_(), this.m_21172_(Attributes.f_22279_));
            }
            if (this.canLook()) {
                this.m_7618_(EntityAnchorArgument.Anchor.EYES, this.m_5448_().m_146892_());
            }
        }
        if (!this.isHungry()) {
            this.setHungerCooldown(this.getHungerCooldown() - 1);
        }
    }

    @Override
    public int getBodyRotationSpeed() {
        return 6;
    }

    @Override
    public boolean canRandomSwim() {
        return super.canRandomSwim() && !this.isEat();
    }

    @Override
    public void m_7380_(CompoundTag p_21484_) {
        super.m_7380_(p_21484_);
        p_21484_.m_128405_("Hunger", this.getHungerCooldown());
    }

    @Override
    public void m_7378_(CompoundTag p_21450_) {
        super.m_7378_(p_21450_);
        if (p_21450_.m_128441_("Hunger")) {
            this.setHungerCooldown(p_21450_.m_128451_("Hunger"));
        }
    }

    public float getYHeadSize() {
        return 1.5f;
    }

    public float getHeadSize() {
        return 0.5f;
    }

    public float getHeadDistance() {
        return 2.0f;
    }

    public boolean isHungry() {
        return this.getHungerCooldown() <= 0;
    }

    public void setEat(boolean value) {
        this.f_19804_.m_135381_(IS_EAT, (Object)value);
    }

    public boolean isEat() {
        return (Boolean)this.f_19804_.m_135370_(IS_EAT);
    }

    public void setHungerCooldown(int value) {
        this.f_19804_.m_135381_(HUNGER_COOLDOWN, (Object)value);
    }

    public int getHungerCooldown() {
        return (Integer)this.f_19804_.m_135370_(HUNGER_COOLDOWN);
    }
}

