/*
 * Decompiled with CFR 0.152.
 */
package com.min01.oceanicrealms.entity.ai.control;

import com.min01.oceanicrealms.entity.AbstractOceanicCreature;
import com.min01.oceanicrealms.misc.Boid;
import com.min01.oceanicrealms.util.OceanicUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class BoidMoveControl
extends MoveControl {
    private final int maxTurnX;
    private final float inWaterSpeedModifier;
    private final float outsideWaterSpeedModifier;
    private final boolean applyGravity;
    private boolean forceTarget;
    public Vec3 targetPos = Vec3.f_82478_;
    public final Boid boid;

    public BoidMoveControl(Mob mob, int maxTurnX, float inWaterSpeedModifier, float outsideWaterSpeedModifier, boolean applyGravity) {
        super(mob);
        this.maxTurnX = maxTurnX;
        this.inWaterSpeedModifier = inWaterSpeedModifier;
        this.outsideWaterSpeedModifier = outsideWaterSpeedModifier;
        this.applyGravity = applyGravity;
        this.boid = new Boid(mob);
    }

    public void m_8126_() {
        if (this.applyGravity && this.f_24974_.m_20069_()) {
            this.f_24974_.m_20256_(this.f_24974_.m_20184_().m_82520_(0.0, 0.005, 0.0));
        }
        if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
            if (!this.forceTarget && (this.f_24974_.f_19797_ % 60 == 0 || this.targetPos.equals((Object)Vec3.f_82478_))) {
                this.generateNewTarget();
            }
            this.boid.tick();
            this.stayInWater();
            Vec3 direction = this.f_24974_.m_20184_();
            double d0 = direction.f_82479_;
            double d1 = direction.f_82480_;
            double d2 = direction.f_82481_;
            double d3 = d0 * d0 + d1 * d1 + d2 * d2;
            if (d3 < 2.500000277905201E-7) {
                this.f_24974_.m_21564_(0.0f);
            } else {
                float f = -((float)(Mth.m_14136_((double)direction.f_82479_, (double)direction.f_82481_) * 57.2957763671875));
                this.f_24974_.m_146922_(this.m_24991_(this.f_24974_.m_146908_(), f, 10.0f));
                this.f_24974_.f_20883_ = this.f_24974_.m_146908_();
                this.f_24974_.f_20885_ = this.f_24974_.m_146908_();
                float f1 = (float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_));
                if (this.f_24974_.m_20069_()) {
                    this.f_24974_.m_7910_(f1 * this.inWaterSpeedModifier);
                    if (Math.abs(direction.f_82480_) > (double)1.0E-5f || Math.abs(direction.m_165924_()) > (double)1.0E-5f) {
                        float f3 = -((float)(Mth.m_14136_((double)direction.f_82480_, (double)direction.m_165924_()) * 57.2957763671875));
                        f3 = Mth.m_14036_((float)Mth.m_14177_((float)f3), (float)(-this.maxTurnX), (float)this.maxTurnX);
                        this.f_24974_.m_146926_(this.m_24991_(this.f_24974_.m_146909_(), f3, 5.0f));
                    }
                    float f6 = Mth.m_14089_((float)(this.f_24974_.m_146909_() * ((float)Math.PI / 180)));
                    float f4 = Mth.m_14031_((float)(this.f_24974_.m_146909_() * ((float)Math.PI / 180)));
                    this.f_24974_.f_20902_ = f6 * f1;
                    this.f_24974_.f_20901_ = -f4 * f1;
                } else {
                    float f5 = Math.abs(Mth.m_14177_((float)(this.f_24974_.m_146908_() - f)));
                    float f2 = this.getTurningSpeedFactor(f5);
                    this.f_24974_.m_7910_(f1 * this.outsideWaterSpeedModifier * f2);
                }
            }
        } else {
            this.f_24974_.m_7910_(0.0f);
            this.f_24974_.m_21570_(0.0f);
            this.f_24974_.m_21567_(0.0f);
            this.f_24974_.m_21564_(0.0f);
        }
    }

    private void generateNewTarget() {
        Level world = this.f_24974_.f_19853_;
        AbstractOceanicCreature fish = (AbstractOceanicCreature)this.f_24974_;
        for (int i = 0; i < 10; ++i) {
            BlockHitResult blockHit;
            BlockPos targetPos;
            BlockState blockState;
            Vec3 pos = OceanicUtil.getSpreadPosition((Entity)this.f_24974_, fish.getSwimRadius());
            BlockHitResult hitResult = this.f_24974_.f_19853_.m_45547_(new ClipContext(this.f_24974_.m_20182_(), pos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.f_24974_));
            if (!(hitResult instanceof BlockHitResult) || !(blockState = world.m_8055_(targetPos = (blockHit = hitResult).m_82425_())).m_60713_(Blocks.f_49990_)) continue;
            this.targetPos = blockHit.m_82450_();
            break;
        }
    }

    private float getTurningSpeedFactor(float p_249853_) {
        return 1.0f - Mth.m_14036_((float)((p_249853_ - 10.0f) / 50.0f), (float)0.0f, (float)1.0f);
    }

    public void stayInWater() {
        if (this.f_24974_.m_20069_()) {
            BlockPos blockPos = this.f_24974_.m_20183_();
            BlockState blockAbove = this.f_24974_.f_19853_.m_8055_(blockPos.m_6630_(2));
            BlockState blockBelow = this.f_24974_.f_19853_.m_8055_(blockPos.m_6625_(1));
            float amount = this.amount();
            if (blockBelow.m_60819_().m_76178_()) {
                this.f_24974_.m_246865_(new Vec3(0.0, (double)amount, 0.0));
            }
            if (blockAbove.m_60819_().m_76178_()) {
                this.f_24974_.m_246865_(new Vec3(0.0, (double)(-amount), 0.0));
            }
        }
    }

    public float amount() {
        float amount = 0.05f;
        float dY = Mth.m_14154_((float)((float)this.f_24974_.m_20184_().f_82480_));
        if (dY > amount) {
            amount = dY;
        }
        return amount;
    }

    public void setTargetPos(Vec3 pos) {
        this.targetPos = pos;
    }

    public void setForceTarget(Vec3 pos) {
        this.targetPos = pos;
        this.forceTarget = true;
    }

    public void setForceTarget(boolean forceTarget) {
        this.forceTarget = forceTarget;
        if (!forceTarget) {
            this.generateNewTarget();
        }
    }

    public Vec3 getTargetPos() {
        return this.targetPos;
    }
}

