/*
 * Decompiled with CFR 0.152.
 */
package com.min01.oceanicrealms.entity.living;

import com.min01.oceanicrealms.config.OceanicConfig;
import com.min01.oceanicrealms.entity.AbstractAnimatableCreature;
import com.min01.oceanicrealms.misc.SmoothAnimationState;
import com.min01.oceanicrealms.network.OceanicNetwork;
import com.min01.oceanicrealms.network.UpdateCrabDancePacket;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.TurtleEggBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;

public class EntityCrab
extends AbstractAnimatableCreature {
    public static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(EntityCrab.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> DIG_OUT_TICK = SynchedEntityData.m_135353_(EntityCrab.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Float> SIZE = SynchedEntityData.m_135353_(EntityCrab.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<BlockPos> HOLE_POS = SynchedEntityData.m_135353_(EntityCrab.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    public static final EntityDataAccessor<Boolean> IS_DANCE = SynchedEntityData.m_135353_(EntityCrab.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> IS_DIGGING = SynchedEntityData.m_135353_(EntityCrab.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public final SmoothAnimationState idleAnimationState = new SmoothAnimationState();
    public final SmoothAnimationState danceAnimationState = new SmoothAnimationState();
    public final SmoothAnimationState eatingAnimationState = new SmoothAnimationState();
    public final SmoothAnimationState digAnimationState = new SmoothAnimationState();
    public final SmoothAnimationState digOutAnimationState = new SmoothAnimationState();
    @Nullable
    public BlockPos jukebox;

    public EntityCrab(EntityType<? extends PathfinderMob> p_33002_, Level p_33003_) {
        super(p_33002_, p_33003_);
        this.m_274367_(1.5f);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public boolean m_6914_(LevelReader p_21433_) {
        return p_21433_.m_45784_((Entity)this);
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 5.0).m_22268_(Attributes.f_22279_, (double)0.45f);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)this.f_19796_.m_216339_(1, 4));
        this.f_19804_.m_135372_(DIG_OUT_TICK, (Object)0);
        this.f_19804_.m_135372_(SIZE, (Object)Float.valueOf(0.7f + (float)Math.random() * 0.50000006f));
        this.f_19804_.m_135372_(HOLE_POS, (Object)BlockPos.f_121853_);
        this.f_19804_.m_135372_(IS_DANCE, (Object)false);
        this.f_19804_.m_135372_(IS_DIGGING, (Object)false);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(4, (Goal)new RandomStrollGoal(this, 0.45f, 60){

            public boolean m_8036_() {
                return super.m_8036_() && !EntityCrab.this.isDance() && !EntityCrab.this.shouldDig();
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal<Player>((PathfinderMob)this, Player.class, 10.0f, 0.8, 0.8){

            public boolean m_8036_() {
                return super.m_8036_() && !EntityCrab.this.shouldDig();
            }

            public void m_8056_() {
                EntityCrab.this.setDance(false);
                EntityCrab.this.setAnimationState(0);
                super.m_8056_();
            }
        });
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.m_6210_();
        if (this.f_19853_.f_46443_) {
            this.idleAnimationState.updateWhen(this.getAnimationState() == 0 && !this.isDance() && !this.isDigging(), this.f_19797_);
            this.danceAnimationState.updateWhen(this.isDance() && !this.isDigging(), this.f_19797_);
            this.eatingAnimationState.updateWhen(this.isUsingSkill(1) && !this.isDigging(), this.f_19797_);
            this.digAnimationState.updateWhen(this.isUsingSkill(2), this.f_19797_);
            this.digOutAnimationState.updateWhen(this.isUsingSkill(3), this.f_19797_);
        }
        if (this.jukebox == null || !this.jukebox.m_203195_((Position)this.m_20182_(), 3.46) || !this.f_19853_.m_8055_(this.jukebox).m_60713_(Blocks.f_50131_)) {
            this.setDance(false);
            this.jukebox = null;
            if (this.f_19853_.f_46443_) {
                OceanicNetwork.sendToServer(new UpdateCrabDancePacket(this.m_20148_(), this.isDance(), this.jukebox == null ? BlockPos.f_121853_ : this.jukebox));
            }
        }
        if (!this.shouldDig()) {
            if (this.f_19796_.m_188503_(500) == 0 && this.getAnimationState() == 0) {
                this.setAnimationState(1);
                this.setAnimationTick(30);
            }
        } else if (!this.isDigging() && !this.m_20075_().m_60795_()) {
            this.setDigging(true);
            this.m_21573_().m_26573_();
            this.m_20256_(Vec3.f_82478_);
            this.f_21345_.m_25386_().forEach(WrappedGoal::m_8041_);
            this.setAnimationState(2);
            this.setAnimationTick(20);
            this.setDigOutTick(80);
        }
        if (this.isDigging()) {
            this.m_21573_().m_26573_();
            this.m_20256_(Vec3.f_82478_);
            this.f_21345_.m_25386_().forEach(WrappedGoal::m_8041_);
            BlockPos groundPos = this.f_19853_.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, this.m_20183_());
            if (this.getAnimationState() == 2) {
                if (this.m_20183_().m_123331_((Vec3i)groundPos) <= 3.0) {
                    this.f_19853_.m_7605_((Entity)this, (byte)99);
                    this.m_20256_(Vec3.f_82478_);
                    this.m_20219_(this.m_20182_().m_82492_(0.0, (double)((float)(20 - this.getAnimationTick()) * 0.003f), 0.0));
                } else if (this.getDigOutTick() <= 0 && !this.shouldDig()) {
                    this.m_20219_(this.m_20182_().m_82520_(0.0, (double)0.3f, 0.0));
                    this.setAnimationState(3);
                    this.setAnimationTick(35);
                }
            }
            if (this.getAnimationState() == 3) {
                if (this.f_19853_.m_8055_(this.m_20183_()).m_60838_((BlockGetter)this.f_19853_, this.m_20183_())) {
                    this.m_20256_(Vec3.f_82478_);
                    this.m_20219_(this.m_20182_().m_82520_(0.0, (double)((float)(35 - this.getAnimationTick()) * 0.003f), 0.0));
                } else if (this.getAnimationTick() <= 0) {
                    this.setAnimationState(0);
                    this.setDigging(false);
                }
            }
        }
        if (this.getAnimationTick() <= 0 && this.getAnimationState() == 1) {
            this.setAnimationState(0);
        }
        if (!this.isNight() && this.getDigOutTick() > 0) {
            this.setDigOutTick(this.getDigOutTick() - 1);
        }
    }

    public boolean shouldDig() {
        Player player = this.f_19853_.m_45924_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 2.5, true);
        return player != null || this.isNight();
    }

    public int m_5792_() {
        return 7;
    }

    public boolean isNight() {
        return this.f_19853_.m_8044_() % 24000L >= 13000L;
    }

    public static boolean checkCrabSpawnRules(EntityType<EntityCrab> type, ServerLevelAccessor pServerLevel, MobSpawnType pMobSpawnType, BlockPos pPos, RandomSource pRandom) {
        Structure structure = (Structure)pServerLevel.m_9598_().m_175515_(Registries.f_256944_).m_6246_(BuiltinStructures.f_209853_);
        ServerLevel level = pServerLevel.m_6018_();
        boolean isWater = pServerLevel.m_8055_(pPos).m_60713_(Blocks.f_49990_) || pServerLevel.m_8055_(pPos.m_7495_()).m_60713_(Blocks.f_49990_) || pServerLevel.m_8055_(pPos.m_7494_()).m_60713_(Blocks.f_49990_);
        boolean isLand = TurtleEggBlock.m_57762_((BlockGetter)pServerLevel, (BlockPos)pPos) || pServerLevel.m_8055_(pPos.m_7495_()).m_60713_(Blocks.f_50440_) || pServerLevel.m_8055_(pPos.m_7495_()).m_60713_(Blocks.f_220864_);
        boolean isShipwreck = level.m_215010_().m_220524_(pPos, structure).m_73603_();
        if (((Boolean)OceanicConfig.spawnCrabs.get()).booleanValue()) {
            return isWater || isLand || isShipwreck;
        }
        return false;
    }

    public void m_7822_(byte p_21375_) {
        super.m_7822_(p_21375_);
        if (p_21375_ == 99) {
            RandomSource random = this.m_217043_();
            BlockState blockState = this.m_20075_();
            if (blockState.m_60799_() != RenderShape.INVISIBLE) {
                for (int i = 0; i < 5; ++i) {
                    double d0 = this.m_20185_() + (double)Mth.m_216283_((RandomSource)random, (float)-0.3f, (float)0.3f);
                    double d1 = this.m_20186_();
                    double d2 = this.m_20189_() + (double)Mth.m_216283_((RandomSource)random, (float)-0.3f, (float)0.3f);
                    this.f_19853_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockState), d0, d1, d2, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public boolean m_6469_(DamageSource p_21016_, float p_21017_) {
        if (p_21016_.m_276093_(DamageTypes.f_268612_)) {
            return false;
        }
        return super.m_6469_(p_21016_, p_21017_);
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_6063_() {
        return false;
    }

    protected boolean m_6129_() {
        return false;
    }

    public void m_6818_(BlockPos p_29395_, boolean p_29396_) {
        if (this.getAnimationState() == 0) {
            this.jukebox = p_29395_;
            this.setDance(p_29396_);
            OceanicNetwork.sendToServer(new UpdateCrabDancePacket(this.m_20148_(), this.isDance(), this.jukebox == null ? BlockPos.f_121853_ : this.jukebox));
        }
    }

    public float m_6134_() {
        return this.getSize();
    }

    @Override
    public void m_7380_(CompoundTag p_21484_) {
        super.m_7380_(p_21484_);
        p_21484_.m_128405_("Variant", this.getVariant());
        p_21484_.m_128405_("DigOutTick", this.getDigOutTick());
        p_21484_.m_128350_("Size", this.getSize());
        if (this.getHolePos() != BlockPos.f_121853_) {
            p_21484_.m_128365_("HolePos", (Tag)NbtUtils.m_129224_((BlockPos)this.getHolePos()));
        }
        p_21484_.m_128379_("isDance", this.isDance());
        p_21484_.m_128379_("isDigging", this.isDigging());
    }

    @Override
    public void m_7378_(CompoundTag p_21450_) {
        super.m_7378_(p_21450_);
        this.setVariant(p_21450_.m_128451_("Variant"));
        this.setDigOutTick(p_21450_.m_128451_("DigOutTick"));
        this.setSize(p_21450_.m_128457_("Size"));
        if (p_21450_.m_128441_("HolePos")) {
            this.setHolePos(NbtUtils.m_129239_((CompoundTag)p_21450_.m_128469_("HolePos")));
        }
        this.setDance(p_21450_.m_128471_("isDance"));
        this.setDigging(p_21450_.m_128471_("isDigging"));
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor p_21434_, DifficultyInstance p_21435_, MobSpawnType p_21436_, SpawnGroupData p_21437_, CompoundTag p_21438_) {
        if (p_21434_.m_204166_(this.m_20183_()).m_203656_(Tags.Biomes.IS_SWAMP)) {
            this.setVariant(4);
        }
        return super.m_6518_(p_21434_, p_21435_, p_21436_, p_21437_, p_21438_);
    }

    public void setDigging(boolean value) {
        this.f_19804_.m_135381_(IS_DIGGING, (Object)value);
    }

    public boolean isDigging() {
        return (Boolean)this.f_19804_.m_135370_(IS_DIGGING);
    }

    public void setDance(boolean value) {
        this.f_19804_.m_135381_(IS_DANCE, (Object)value);
    }

    public boolean isDance() {
        return (Boolean)this.f_19804_.m_135370_(IS_DANCE);
    }

    public void setHolePos(BlockPos value) {
        this.f_19804_.m_135381_(HOLE_POS, (Object)value);
    }

    public BlockPos getHolePos() {
        return (BlockPos)this.f_19804_.m_135370_(HOLE_POS);
    }

    public void setSize(float value) {
        this.f_19804_.m_135381_(SIZE, (Object)Float.valueOf(value));
    }

    public float getSize() {
        return ((Float)this.f_19804_.m_135370_(SIZE)).floatValue();
    }

    public void setDigOutTick(int value) {
        this.f_19804_.m_135381_(DIG_OUT_TICK, (Object)value);
    }

    public int getDigOutTick() {
        return (Integer)this.f_19804_.m_135370_(DIG_OUT_TICK);
    }

    public void setVariant(int value) {
        this.f_19804_.m_135381_(VARIANT, (Object)value);
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }
}

