/*
 * Decompiled with CFR 0.152.
 */
package com.min01.oceanicrealms.entity.living;

import com.min01.oceanicrealms.entity.AgeableWaterAnimal;
import com.min01.oceanicrealms.entity.OceanicEntities;
import com.min01.oceanicrealms.entity.living.AbstractOarfishPart;
import com.min01.oceanicrealms.entity.living.EntityOarfishBody;
import com.min01.oceanicrealms.entity.living.EntityOarfishTail;
import com.min01.oceanicrealms.misc.KinematicChain;
import com.min01.oceanicrealms.util.OceanicUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;

public class EntityOarfishHead
extends AbstractOarfishPart {
    public static final EntityDataAccessor<Integer> MAX_LENGTH = SynchedEntityData.m_135353_(EntityOarfishHead.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public KinematicChain chain;

    public EntityOarfishHead(EntityType<? extends AgeableWaterAnimal> p_33002_, Level p_33003_) {
        super(p_33002_, p_33003_);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22279_, (double)0.35f);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MAX_LENGTH, (Object)0);
    }

    @Override
    public boolean isHead() {
        return true;
    }

    @Override
    public int getBodyRotationSpeed() {
        return 6;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.chain == null) {
            this.chain = new KinematicChain((Entity)this, this.getMaxLength(), 1.35f);
        } else {
            this.chain.setOldPosAndRot();
            this.chain.tick();
            this.chain.getSegments()[0].setDistance(1.5f);
            this.chain.setTarget(OceanicUtil.getLookPos(this.m_20155_(), this.m_20182_(), 0.0, 0.0, -1.35f));
        }
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor p_21434_, DifficultyInstance p_21435_, MobSpawnType p_21436_, SpawnGroupData p_21437_, CompoundTag p_21438_) {
        int length = this.f_19796_.m_216339_(8, 13);
        this.setMaxLength(length);
        AbstractOarfishPart prev = this;
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                EntityOarfishBody body = new EntityOarfishBody((EntityType<? extends AgeableWaterAnimal>)((EntityType)OceanicEntities.OARFISH_BODY.get()), this.f_19853_);
                body.m_146884_(this.m_20182_());
                body.setOwner(prev);
                body.setHead(this);
                body.setIndex(i);
                prev = body;
                this.f_19853_.m_7967_((Entity)body);
                continue;
            }
            EntityOarfishTail tail = new EntityOarfishTail((EntityType<? extends AgeableWaterAnimal>)((EntityType)OceanicEntities.OARFISH_TAIL.get()), this.f_19853_);
            tail.m_146884_(this.m_20182_());
            tail.setOwner(prev);
            tail.setHead(this);
            tail.setIndex(i);
            this.f_19853_.m_7967_((Entity)tail);
        }
        return super.m_6518_(p_21434_, p_21435_, p_21436_, p_21437_, p_21438_);
    }

    @Override
    public void m_7380_(CompoundTag p_37265_) {
        super.m_7380_(p_37265_);
        p_37265_.m_128405_("MaxLength", this.getMaxLength());
    }

    @Override
    public void m_7378_(CompoundTag p_37262_) {
        super.m_7378_(p_37262_);
        if (p_37262_.m_128441_("MaxLength")) {
            this.setMaxLength(p_37262_.m_128451_("MaxLength"));
        }
    }

    @Override
    public Vec3 getSwimRadius() {
        return new Vec3(15.0, 4.0, 15.0);
    }

    public void setMaxLength(int value) {
        this.f_19804_.m_135381_(MAX_LENGTH, (Object)value);
    }

    public int getMaxLength() {
        return (Integer)this.f_19804_.m_135370_(MAX_LENGTH);
    }
}

