/*
 * Decompiled with CFR 0.152.
 */
package com.min01.oceanicrealms.misc;

import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class OceanicEntityDataSerializers {
    public static final DeferredRegister<EntityDataSerializer<?>> SERIALIZERS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.ENTITY_DATA_SERIALIZERS, (String)"oceanicrealms");
    public static final RegistryObject<EntityDataSerializer<Vec3>> VEC3 = SERIALIZERS.register("serializer_vec3", () -> EntityDataSerializer.m_238095_(OceanicEntityDataSerializers::writeVec3, OceanicEntityDataSerializers::readVec3));

    public static CompoundTag writeVec3(CompoundTag tag, Vec3 vec) {
        tag.m_128347_("X", vec.f_82479_);
        tag.m_128347_("Y", vec.f_82480_);
        tag.m_128347_("Z", vec.f_82481_);
        return tag;
    }

    public static Vec3 readVec3(CompoundTag tag) {
        return new Vec3(tag.m_128459_("X"), tag.m_128459_("Y"), tag.m_128459_("Z"));
    }

    public static ByteBuf writeVec3(FriendlyByteBuf buf, Vec3 vec) {
        buf.writeDouble(vec.f_82479_);
        buf.writeDouble(vec.f_82480_);
        buf.writeDouble(vec.f_82481_);
        return buf;
    }

    public static Vec3 readVec3(ByteBuf buf) {
        return new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
    }
}

