/*
 * Decompiled with CFR 0.152.
 */
package com.min01.oceanicrealms.misc;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class WormChain {
    public static void tick(Worm worm, LivingEntity owner, float distance, float speed) {
        Vec3 direction = owner.m_20154_().m_82541_().m_82490_((double)distance);
        Vec3 targetPos = Vec3.f_82478_.m_82546_(direction);
        worm.setPos(targetPos);
        float prevYRot = worm.getYRot();
        float prevXRot = worm.getXRot();
        worm.setYRot(owner.m_146908_());
        worm.setXRot(owner.m_146909_());
        float yRotDiff = Mth.m_14177_((float)(owner.m_146908_() - prevYRot));
        float xRotDiff = Mth.m_14177_((float)(owner.m_146909_() - prevXRot));
        worm.setYRot(prevYRot + yRotDiff * speed);
        worm.setXRot(prevXRot + xRotDiff * speed);
        worm.setYBodyRot(worm.getYRot());
        worm.setYHeadRot(worm.getYRot());
    }

    public static void tick(Worm worm, Worm owner, float distance, float speed) {
        Vec3 direction = owner.getLookAngle().m_82541_().m_82490_((double)distance);
        Vec3 targetPos = owner.position().m_82546_(direction);
        worm.setPos(targetPos);
        float prevYRot = worm.getYRot();
        float prevXRot = worm.getXRot();
        worm.setYRot(owner.getYRot());
        worm.setXRot(owner.getXRot());
        float yRotDiff = Mth.m_14177_((float)(owner.getYRot() - prevYRot));
        float xRotDiff = Mth.m_14177_((float)(owner.getXRot() - prevXRot));
        worm.setYRot(prevYRot + yRotDiff * speed);
        worm.setXRot(prevXRot + xRotDiff * speed);
        worm.setYBodyRot(worm.getYRot());
        worm.setYHeadRot(worm.getYRot());
    }

    public static class Worm {
        private float yRot;
        private float xRot;
        public float yRotO;
        public float xRotO;
        public float yBodyRot;
        public float yBodyRotO;
        public float yHeadRot;
        public float yHeadRotO;
        public double xOld;
        public double yOld;
        public double zOld;
        private Vec3 position = Vec3.f_82478_;

        public void setPos(Vec3 pos) {
            this.position = pos;
        }

        public Vec3 position() {
            return this.position;
        }

        public Vec3 position(float partialTicks) {
            double x = Mth.m_14139_((double)partialTicks, (double)this.xOld, (double)this.getX());
            double y = Mth.m_14139_((double)partialTicks, (double)this.yOld, (double)this.getY());
            double z = Mth.m_14139_((double)partialTicks, (double)this.zOld, (double)this.getZ());
            return new Vec3(x, y, z);
        }

        public Vec2 getRot(float partialTick) {
            float xRot = Mth.m_14179_((float)partialTick, (float)this.xRotO, (float)this.getXRot());
            float yRot = Mth.m_14189_((float)partialTick, (float)this.yBodyRotO, (float)this.yBodyRot);
            return new Vec2(xRot, yRot);
        }

        public void setOldPosAndRot() {
            this.xOld = this.getX();
            this.yOld = this.getY();
            this.zOld = this.getZ();
            this.xRotO = this.getXRot();
            this.yBodyRotO = this.yBodyRot;
        }

        public double getX() {
            return this.position.f_82479_;
        }

        public double getY() {
            return this.position.f_82480_;
        }

        public double getZ() {
            return this.position.f_82481_;
        }

        public Vec3 getLookAngle() {
            return this.calculateViewVector(this.getXRot(), this.getYRot());
        }

        protected final Vec3 calculateViewVector(float xRot, float yRot) {
            float f = xRot * ((float)Math.PI / 180);
            float f1 = -yRot * ((float)Math.PI / 180);
            float f2 = Mth.m_14089_((float)f1);
            float f3 = Mth.m_14031_((float)f1);
            float f4 = Mth.m_14089_((float)f);
            float f5 = Mth.m_14031_((float)f);
            return new Vec3((double)(f3 * f4), (double)(-f5), (double)(f2 * f4));
        }

        public float getYRot() {
            return this.yRot;
        }

        public void setYRot(float yRot) {
            if (Float.isFinite(yRot)) {
                this.yRot = yRot;
            }
        }

        public float getXRot() {
            return this.xRot;
        }

        public void setXRot(float xRot) {
            if (Float.isFinite(xRot)) {
                this.xRot = xRot;
            }
        }

        public void setYHeadRot(float yHeadRot) {
            this.yHeadRot = yHeadRot;
        }

        public void setYBodyRot(float yBodyRot) {
            this.yBodyRot = yBodyRot;
        }
    }
}

