/*
 * Decompiled with CFR 0.152.
 */
package one.devos.nautical.up_and_away.content.balloon.entity;

import com.mojang.serialization.Codec;
import java.util.Locale;
import java.util.Objects;
import java.util.function.IntFunction;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1313;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3542;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5253;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import net.minecraft.class_7995;
import net.minecraft.class_8103;
import net.minecraft.class_8710;
import net.minecraft.class_9282;
import net.minecraft.class_9326;
import net.minecraft.class_9334;
import one.devos.nautical.up_and_away.UpAndAway;
import one.devos.nautical.up_and_away.content.UpAndAwayComponents;
import one.devos.nautical.up_and_away.content.balloon.BalloonShape;
import one.devos.nautical.up_and_away.content.balloon.entity.attachment.BalloonAttachment;
import one.devos.nautical.up_and_away.content.balloon.entity.attachment.BlockBalloonAttachment;
import one.devos.nautical.up_and_away.content.balloon.entity.attachment.EntityBalloonAttachment;
import one.devos.nautical.up_and_away.content.balloon.entity.packet.BalloonDetachPacket;
import one.devos.nautical.up_and_away.content.balloon.entity.packet.BlockBalloonAttachmentPacket;
import one.devos.nautical.up_and_away.content.balloon.entity.packet.EntityBalloonAttachmentPacket;
import one.devos.nautical.up_and_away.content.balloon.item.BalloonItem;
import one.devos.nautical.up_and_away.content.balloon.item.DeflatedBalloonItem;
import one.devos.nautical.up_and_away.framework.entity.ExtraSpawnPacketsEntity;
import one.devos.nautical.up_and_away.framework.entity.SometimesSerializableEntity;
import one.devos.nautical.up_and_away.framework.util.Utils;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

public abstract class AbstractBalloon
extends class_1297
implements ExtraSpawnPacketsEntity,
SometimesSerializableEntity {
    public static final class_2940<Byte> SHAPE_ID = class_2945.method_12791(AbstractBalloon.class, (class_2941)class_2943.field_13319);
    public static final class_2940<Byte> MODE_ID = class_2945.method_12791(AbstractBalloon.class, (class_2941)class_2943.field_13319);
    public static final class_2940<Integer> COLOR = class_2945.method_12791(AbstractBalloon.class, (class_2941)class_2943.field_13327);
    public static final BalloonShape DEFAULT_SHAPE = BalloonShape.ROUND;
    public static final int DEFAULT_COLOR = -1;
    public static final int[] RANDOM_COLORS = new int[]{-1668571, -2011857, -11746592, -11344466, -1327821, -1035879};
    public static final String SHAPE_KEY = "shape";
    public static final String COLOR_KEY = "color";
    public static final String ATTACHMENT_KEY = "attachment";
    public static final String MODE_KEY = "mode";
    public static final class_6862<class_2248> SHARP_BLOCKS = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)UpAndAway.id("pops_balloons"));
    public static final class_6862<class_1792> SHARP_ITEMS = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)UpAndAway.id("pops_balloons"));
    public static final class_6862<class_1299<?>> SHARP_ENTITIES = class_6862.method_40092((class_5321)class_7924.field_41266, (class_2960)UpAndAway.id("pops_balloons"));
    private BalloonAttachment attachment;
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;

    protected AbstractBalloon(class_1299<?> entityType, class_1937 level) {
        super(entityType, level);
        this.field_23807 = true;
    }

    protected AbstractBalloon(class_1299<?> type, class_1937 level, class_1799 stack, @Nullable BalloonAttachment attachment) {
        this(type, level);
        this.setAttachment(attachment);
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof BalloonItem) {
            BalloonItem item = (BalloonItem)class_17922;
            this.field_6011.method_12778(SHAPE_ID, (Object)item.shape.id);
        }
        if (stack.method_57826(UpAndAwayComponents.BALLOON_MODE)) {
            Mode mode = Objects.requireNonNull((Mode)((Object)stack.method_57824(UpAndAwayComponents.BALLOON_MODE)));
            this.field_6011.method_12778(MODE_ID, (Object)mode.id);
        }
        this.field_6011.method_12778(COLOR, (Object)AbstractBalloon.getColor(stack, this.field_5974));
    }

    protected abstract class_1792 baseItem();

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(SHAPE_ID, (Object)AbstractBalloon.DEFAULT_SHAPE.id);
        builder.method_56912(MODE_ID, (Object)Mode.NORMAL.id);
        builder.method_56912(COLOR, (Object)-1);
    }

    public void method_5674(class_2940<?> data) {
        super.method_5674(data);
        if (SHAPE_ID.equals(data)) {
            this.method_18382();
        }
    }

    protected void method_5749(class_2487 nbt) {
        Utils.simpleDecodeSafe(BalloonShape.CODEC, nbt, SHAPE_KEY).ifPresent(shape -> this.field_6011.method_12778(SHAPE_ID, (Object)shape.id));
        Utils.simpleDecodeSafe(Mode.CODEC, nbt, MODE_KEY).ifPresent(mode -> this.field_6011.method_12778(MODE_ID, (Object)mode.id));
        this.field_6011.method_12778(COLOR, (Object)class_5253.class_5254.method_57174((int)nbt.method_10550(COLOR_KEY)));
        if (nbt.method_10573(ATTACHMENT_KEY, 10)) {
            class_2487 tag = nbt.method_10562(ATTACHMENT_KEY);
            this.attachment = BlockBalloonAttachment.fromNbt(tag, this.method_37908());
        }
    }

    protected void method_5652(class_2487 nbt) {
        nbt.method_10582(SHAPE_KEY, this.shape().name);
        if (this.mode() != Mode.NORMAL) {
            nbt.method_10582(MODE_KEY, this.mode().name);
        }
        nbt.method_10569(COLOR_KEY, this.color());
        if (this.attachment instanceof BlockBalloonAttachment) {
            nbt.method_10566(ATTACHMENT_KEY, (class_2520)this.attachment.toNbt());
        }
    }

    @Override
    public boolean isSerializable() {
        return this.attachment == null || this.attachment instanceof BlockBalloonAttachment;
    }

    public class_2487 saveWithoutAttachment() {
        BalloonAttachment attachment = this.attachment;
        this.attachment = null;
        class_2487 nbt = new class_2487();
        try {
            this.method_5662(nbt);
        }
        finally {
            this.attachment = attachment;
        }
        return nbt;
    }

    @Override
    public void addSpawnPackets(ExtraSpawnPacketsEntity.PacketConsumer consumer) {
        BalloonAttachment balloonAttachment = this.attachment;
        if (balloonAttachment instanceof BlockBalloonAttachment) {
            BlockBalloonAttachment block = (BlockBalloonAttachment)balloonAttachment;
            consumer.add(new BlockBalloonAttachmentPacket(this, block));
        } else {
            balloonAttachment = this.attachment;
            if (balloonAttachment instanceof EntityBalloonAttachment) {
                EntityBalloonAttachment entity = (EntityBalloonAttachment)balloonAttachment;
                consumer.add(new EntityBalloonAttachmentPacket(this, entity));
            }
        }
    }

    public void method_5759(double x, double y, double z, float yaw, float pitch, int interpolationSteps) {
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpSteps = interpolationSteps;
    }

    public double method_53830() {
        return this.lerpSteps > 0 ? this.lerpX : this.method_23317();
    }

    public double method_53827() {
        return this.lerpSteps > 0 ? this.lerpY : this.method_23318();
    }

    public double method_53828() {
        return this.lerpSteps > 0 ? this.lerpZ : this.method_23321();
    }

    public void method_5773() {
        if (this.isFixed()) {
            return;
        }
        super.method_5773();
        if (!this.method_37908().field_9236) {
            this.lerpSteps = 0;
            this.method_56990();
            this.applyAirDrag();
            this.handleAttachment();
            this.method_5784(class_1313.field_6308, this.method_18798());
            this.checkSharpBlocks();
        } else {
            this.method_18799(class_243.field_1353);
        }
        if (this.lerpSteps > 0) {
            this.method_52532(this.lerpSteps, this.lerpX, this.lerpY, this.lerpZ, this.method_36454(), this.method_36455());
            --this.lerpSteps;
        }
    }

    private void applyAirDrag() {
        this.method_18799(this.method_18798().method_18805(0.91, 1.0, 0.91));
    }

    private void handleAttachment() {
        if (this.attachment == null) {
            return;
        }
        if (!this.method_37908().field_9236 && !this.attachment.validate()) {
            this.detach();
            return;
        }
        if (this.attachment.shouldTeleport(this.method_19538())) {
            class_243 pos = this.attachment.getPos();
            this.method_5859(pos.field_1352, pos.field_1351, pos.field_1350);
        }
    }

    private void checkSharpBlocks() {
        if (!this.method_5655() && this.anyCollidingBlocksAreSharp()) {
            this.pop();
        }
    }

    private boolean anyCollidingBlocksAreSharp() {
        return class_2338.method_29715((class_238)this.method_5829().method_1014(1.0E-4)).anyMatch(pos -> this.method_37908().method_8320(pos).method_26164(SHARP_BLOCKS));
    }

    public boolean method_5679(class_1282 source) {
        if (this.isFixed() || super.method_5679(source)) {
            return true;
        }
        class_1297 class_12972 = source.method_5526();
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            if (!player.method_7294()) {
                return this.mode() != Mode.VULNERABLE;
            }
            class_1799 held = player.method_6047();
            return !held.method_31573(SHARP_ITEMS);
        }
        return false;
    }

    private boolean isInvulnerableTo(class_1282 source, float amount) {
        if (amount <= 0.0f && !this.isFixed()) {
            class_1297 entity = source.method_5526();
            return entity == null || !entity.method_5864().method_20210(SHARP_ENTITIES);
        }
        return this.method_5679(source);
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (!this.isInvulnerableTo(source, amount)) {
            this.pop();
            return true;
        }
        if (this.isFixed() || source.method_48789(class_8103.field_45065) || this.method_37908().field_9236) {
            return true;
        }
        this.method_5785();
        double dx = 0.0;
        double dz = 0.0;
        class_1297 class_12972 = source.method_5526();
        if (class_12972 instanceof class_1676) {
            class_1676 projectile = (class_1676)class_12972;
            dx = -projectile.method_18798().field_1352;
            dz = -projectile.method_18798().field_1350;
        } else if (source.method_5510() != null) {
            dx = source.method_5510().method_10216() - this.method_23317();
            dz = source.method_5510().method_10215() - this.method_23321();
        }
        this.knockback(0.4, dx, dz);
        return true;
    }

    public void knockback(double strength, double x, double z) {
        if (strength <= 0.0) {
            return;
        }
        this.field_6007 = true;
        class_243 vec3 = this.method_18798();
        while (x * x + z * z < (double)1.0E-5f) {
            x = (Math.random() - Math.random()) * 0.01;
            z = (Math.random() - Math.random()) * 0.01;
        }
        class_243 vec32 = new class_243(x, 0.0, z).method_1029().method_1021(strength);
        this.method_18800(vec3.field_1352 / 2.0 - vec32.field_1352, this.method_24828() ? Math.min(0.4, vec3.field_1351 / 2.0 + strength) : vec3.field_1351, vec3.field_1350 / 2.0 - vec32.field_1350);
    }

    public void pop() {
        class_243 center = this.method_19538().method_1031(0.0, (double)(this.method_17682() / 2.0f), 0.0);
        DeflatedBalloonItem.pop(this.method_37908(), center, this.method_5634());
        if (!this.method_37908().field_9236) {
            this.method_31472();
        }
    }

    public class_238 method_5830() {
        class_238 bounds = super.method_5830();
        if (this.attachment != null) {
            class_243 relativeOffset = this.method_19538().method_1035(this.attachment.getPos());
            bounds = bounds.method_18804(relativeOffset);
        }
        return bounds;
    }

    public void method_5650(class_1297.class_5529 reason) {
        super.method_5650(reason);
        if (this.attachment != null) {
            this.attachment.onRemove(this);
        }
    }

    public void method_36209() {
        if (this.attachment != null) {
            this.attachment.onRemove(this);
        }
    }

    protected class_243 method_29919() {
        return class_243.field_1353;
    }

    public boolean method_5810() {
        return !this.isFixed();
    }

    public boolean method_30949(class_1297 other) {
        return other instanceof AbstractBalloon;
    }

    public boolean method_5863() {
        return true;
    }

    @Nullable
    public class_1799 method_31480() {
        int color = this.color();
        return (class_1799)class_156.method_654((Object)new class_1799((class_1935)this.baseItem()), color != -1 ? stack -> stack.method_57366(class_9326.method_57841().method_57854(class_9334.field_49644, (Object)new class_9282(color, true)).method_57852()) : stack -> {});
    }

    protected class_1297.class_5799 method_33570() {
        return class_1297.class_5799.field_28632;
    }

    public class_4048 method_18377(class_4050 pose) {
        return this.shape().dimensions;
    }

    public BalloonShape shape() {
        return BalloonShape.BY_ID.apply(((Byte)this.field_6011.method_12789(SHAPE_ID)).byteValue());
    }

    public Mode mode() {
        return Mode.BY_ID.apply(((Byte)this.field_6011.method_12789(MODE_ID)).byteValue());
    }

    public int color() {
        return (Integer)this.field_6011.method_12789(COLOR);
    }

    public boolean hasAttachment() {
        return this.attachment != null;
    }

    public @UnknownNullability(value="hasAttachment") BalloonAttachment attachment() {
        return this.attachment;
    }

    public void detach() {
        this.attachment = null;
        if (!this.method_37908().field_9236) {
            BalloonDetachPacket packet = new BalloonDetachPacket(this);
            PlayerLookup.tracking((class_1297)this).forEach(player -> ServerPlayNetworking.send((class_3222)player, (class_8710)packet));
        }
    }

    public void setAttachment(@Nullable BalloonAttachment attachment) {
        this.attachment = attachment;
        if (attachment != null) {
            attachment.onSet(this);
        }
    }

    public boolean isFixed() {
        return this.mode() == Mode.FIXED;
    }

    private static int getColor(class_1799 stack, class_5819 random) {
        if (((Boolean)stack.method_57825(UpAndAwayComponents.RANDOM_COLOR, (Object)false)).booleanValue()) {
            return class_156.method_27172((int[])RANDOM_COLORS, (class_5819)random);
        }
        return class_9282.method_57470((class_1799)stack, (int)-1);
    }

    public static enum Mode implements class_3542
    {
        NORMAL,
        FIXED,
        VULNERABLE;

        public final String name = this.name().toLowerCase(Locale.ROOT);
        public final byte id = (byte)this.ordinal();
        public static final IntFunction<Mode> BY_ID;
        public static final Codec<Mode> CODEC;

        public String method_15434() {
            return this.name;
        }

        static {
            BY_ID = class_7995.method_47914(Enum::ordinal, (Object[])Mode.values(), (class_7995.class_7996)class_7995.class_7996.field_41664);
            CODEC = class_3542.method_28140(Mode::values);
        }
    }
}

