/*
 * Decompiled with CFR 0.152.
 */
package one.devos.nautical.up_and_away.content.balloon.entity;

import java.util.Optional;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_7184;
import one.devos.nautical.up_and_away.content.balloon.entity.BalloonCart;
import one.devos.nautical.up_and_away.content.balloon.entity.renderer.BalloonCartAnimations;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum BalloonCartInteractable {
    HATCH(class_238.method_30048((class_243)new class_243(0.0625, 1.40625, 0.375), (double)1.25, (double)0.125, (double)1.5), new class_243(255.0, 0.0, 0.0), () -> () -> BalloonCartAnimations.HATCH_OPEN, () -> () -> BalloonCartAnimations.HATCH_CLOSE){

        @Override
        public boolean interact(BalloonCart cart, class_1657 player) {
            cart.setInteractableState(this, !cart.getInteractableState(this));
            return true;
        }
    }
    ,
    CHEST(class_238.method_30048((class_243)new class_243(0.875, 0.84375, -0.9375), (double)0.125, (double)0.75, (double)0.75), new class_243(0.0, 255.0, 0.0), () -> () -> BalloonCartAnimations.CHEST_OPEN, () -> () -> BalloonCartAnimations.CHEST_CLOSE){

        @Override
        public boolean interact(BalloonCart cart, class_1657 player) {
            cart.setInteractableState(this, !cart.getInteractableState(this));
            return true;
        }
    }
    ,
    TABLE(class_238.method_30048((class_243)new class_243(0.875, 0.90625, 0.40625), (double)0.1875, (double)0.75, (double)1.8125), new class_243(0.0, 0.0, 255.0), () -> () -> BalloonCartAnimations.TABLE_OPEN, () -> () -> BalloonCartAnimations.TABLE_CLOSE){

        @Override
        public boolean interact(BalloonCart cart, class_1657 player) {
            cart.setInteractableState(this, !cart.getInteractableState(this));
            return true;
        }
    }
    ,
    HELIUM_TANKS(class_238.method_30048((class_243)new class_243(0.0, 1.21875, -1.75), (double)1.75, (double)1.5, (double)0.75), new class_243(255.0, 0.0, 255.0), () -> () -> BalloonCartAnimations.VALVE_OPEN, () -> () -> BalloonCartAnimations.VALVE_CLOSE){

        @Override
        public boolean interact(BalloonCart cart, class_1657 player) {
            cart.setInteractableState(this, !cart.getInteractableState(this));
            return true;
        }
    };

    public static final BalloonCartInteractable[] VALUES;
    public final class_238 hitBox;
    public final class_243 debugColor;
    private final Supplier<Supplier<class_7184>> openAnimationDefinition;
    private final Supplier<Supplier<class_7184>> closeAnimationDefinition;

    private BalloonCartInteractable(class_238 hitBox, class_243 debugColor, Supplier<Supplier<class_7184>> openAnimationDefinition, Supplier<Supplier<class_7184>> closeAnimationDefinition) {
        this.hitBox = hitBox;
        this.debugColor = debugColor;
        this.openAnimationDefinition = openAnimationDefinition;
        this.closeAnimationDefinition = closeAnimationDefinition;
    }

    public abstract boolean interact(BalloonCart var1, class_1657 var2);

    public static Optional<BalloonCartInteractable> raycast(class_243 start, class_243 end) {
        double lastDist = Double.MAX_VALUE;
        Optional<BalloonCartInteractable> closest = Optional.empty();
        for (BalloonCartInteractable interactable : VALUES) {
            double dist;
            Optional clipPoint = interactable.hitBox.method_992(start, end);
            if (!clipPoint.isPresent() || !((dist = start.method_1025((class_243)clipPoint.get())) < lastDist)) continue;
            closest = Optional.of(interactable);
            lastDist = dist;
        }
        return closest;
    }

    @Environment(value=EnvType.CLIENT)
    public class_7184 openAnimationDefinition() {
        return this.openAnimationDefinition.get().get();
    }

    @Environment(value=EnvType.CLIENT)
    public class_7184 closeAnimationDefinition() {
        return this.closeAnimationDefinition.get().get();
    }

    static {
        VALUES = BalloonCartInteractable.values();
    }
}

