/*
 * Decompiled with CFR 0.152.
 */
package one.devos.nautical.up_and_away.content.balloon.entity.attachment;

import com.mojang.serialization.Codec;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_5819;
import one.devos.nautical.up_and_away.content.balloon.entity.AbstractBalloon;
import one.devos.nautical.up_and_away.framework.util.Utils;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class BalloonAttachment {
    public static final String TYPE_KEY = "type";
    public static final String STRING_LENGTH_KEY = "string_length";
    public static final Codec<Double> STRING_LENGTH_CODEC = Codec.doubleRange((double)0.0, (double)Double.MAX_VALUE);
    public static final double BASE_STRING_LENGTH = 4.0;
    public static final double STRING_LENGTH_DEVIATION = 1.0;
    public static final double TELEPORT_THRESHOLD = 15.0;
    public final double stringLength;

    protected BalloonAttachment(double stringLength) {
        this.stringLength = stringLength;
    }

    public abstract boolean validate();

    public abstract class_243 getPos(float var1);

    protected abstract void toNbt(class_2487 var1);

    protected abstract String typeName();

    public void onRemove(AbstractBalloon balloon) {
    }

    public void onSet(AbstractBalloon balloon) {
    }

    public final class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        nbt.method_10582(TYPE_KEY, this.typeName());
        nbt.method_10549(STRING_LENGTH_KEY, this.stringLength);
        this.toNbt(nbt);
        return nbt;
    }

    public final class_243 getPos() {
        return this.getPos(1.0f);
    }

    public final boolean isTooFar(class_243 pos) {
        return pos.method_1022(this.getPos()) > this.stringLength;
    }

    public final boolean shouldTeleport(class_243 pos) {
        return pos.method_1022(this.getPos()) > 15.0;
    }

    public static double getStringLength(class_5819 random) {
        return Utils.nextDouble(random, 3.0, 5.0);
    }
}

