/*
 * Decompiled with CFR 0.152.
 */
package one.devos.nautical.up_and_away.content.balloon.entity.renderer;

import net.minecraft.class_5601;
import net.minecraft.class_630;
import one.devos.nautical.up_and_away.content.balloon.BalloonShape;
import one.devos.nautical.up_and_away.content.balloon.entity.renderer.model.AbstractBalloonModel;
import one.devos.nautical.up_and_away.content.balloon.entity.renderer.model.CubeBalloonModel;
import one.devos.nautical.up_and_away.content.balloon.entity.renderer.model.DogBalloonModel;
import one.devos.nautical.up_and_away.content.balloon.entity.renderer.model.HeartBalloonModel;
import one.devos.nautical.up_and_away.content.balloon.entity.renderer.model.LongBalloonModel;
import one.devos.nautical.up_and_away.content.balloon.entity.renderer.model.RoundBalloonModel;

public class BalloonModels {
    private final CubeBalloonModel cubeModel;
    private final DogBalloonModel dogModel;
    private final HeartBalloonModel heartModel;
    private final LongBalloonModel longModel;
    private final RoundBalloonModel roundModel;

    public BalloonModels(EntityModelBakery bakery) {
        this.cubeModel = new CubeBalloonModel(bakery.bake(CubeBalloonModel.LAYER_LOCATION));
        this.dogModel = new DogBalloonModel(bakery.bake(DogBalloonModel.LAYER_LOCATION));
        this.heartModel = new HeartBalloonModel(bakery.bake(HeartBalloonModel.LAYER_LOCATION));
        this.longModel = new LongBalloonModel(bakery.bake(LongBalloonModel.LAYER_LOCATION));
        this.roundModel = new RoundBalloonModel(bakery.bake(RoundBalloonModel.LAYER_LOCATION));
    }

    public AbstractBalloonModel choose(BalloonShape shape) {
        return switch (shape) {
            default -> throw new IncompatibleClassChangeError();
            case BalloonShape.CUBE -> this.cubeModel;
            case BalloonShape.DOG -> this.dogModel;
            case BalloonShape.HEART -> this.heartModel;
            case BalloonShape.LONG -> this.longModel;
            case BalloonShape.ROUND -> this.roundModel;
        };
    }

    public static interface EntityModelBakery {
        public class_630 bake(class_5601 var1);
    }
}

